
/* Copyright (C) 2001-2008 Monotype Imaging Inc. All rights reserved. */

/* Confidential information of Monotype Imaging Inc. */

/* Copyright: 1987-1990 by Apple Computer, Inc., all rights reserved. */

/* fs_fnt.c -- the TrueType instruction interpreter */


#include "fs_itype.h"

#ifdef FS_HINTS    /* conditionally compile entire module */

#ifdef FS_EDGE_HINTS
ADF_I32 ADFAutohintMAZStroke(fnt_LocalGraphicStateType *gs);
ADF_I32 ADFAutohintMAZOutline(fnt_LocalGraphicStateType *gs);
ADF_I32 ADFAutohintBAZOutline(fnt_LocalGraphicStateType *gs);
ADF_I32 ADFAutohintBAZStroke(fnt_LocalGraphicStateType *gs);
FS_VOID BAZpositionStems(fnt_LocalGraphicStateType *gs);
FS_VOID ADFMAZKeepInBox (fnt_LocalGraphicStateType *gs);
#else
static FS_VOID edgehints_err(fnt_LocalGraphicStateType *gs);
#endif

#define fnt_NextPt1( pt, elem, ctr )    ( (pt) == elem->ep[(ctr)] ? elem->sp[(ctr)] : (pt)+1 )
#define POP( p )    ( *(--p) )
#define PUSH( p, x ) ( *(p)++ = (x) )
#define BOOLEANPUSH( p, x ) PUSH( p, ((x) ? 1 : 0) )

/* we know the answers will fit  in 32 bits */
#define SHORTMUL(a,b) (FS_LONG)((FS_LONG)a * (FS_LONG)b)
#define SHORTDIV(a,b) (FS_LONG)((FS_LONG)a / (FS_LONG)b)

#define ITYPE_UD_FUNCTIONS      1
#define GENERIC_UD_FUNCTIONS    2
#define START_OF_UD_OPCODES     162  /* start of user defined opcode MAZDELTA1 */
#define END_OF_UD_OPCODES       175  /* end of user defined opcode DELTAL3 */


/* glop for debugging the interpreter */
#ifdef FS_DEBUG
/* note: many of the following CHECK_RANGE expressions
* which have min==0, are called with an unsigned test
* object.  Many compilers report a "comparison always
* 0 due to limited range of data type" or something
* similar.  This is nothing to worry about. Honest.
*/
/* this trick gets rid of the warning mentioned above */
FS_LONG trick2LONG(FS_LONG l)
{
    return l;
}
#define CHECK_RANGE(n,min,max)        \
    /*lint -e506 */ if (trick2LONG((n))<(min) || (n)>(max)) oops()
#define CHECK_ASSERTION(exp)        if (!(exp)) oops()
#define CHECK_CVT(gs,cvt)           CHECK_RANGE(cvt,0,gs->globalGS->cvtCount - 1)
#define CHECK_FDEF(gs,fdef)         CHECK_RANGE(fdef,0,gs->globalGS->maxp->maxFunctionDefs - 1)
#define CHECK_PROGRAM(pgm)          if((trick2LONG(pgm)<0) || (trick2LONG(pgm)>(MAXPREPROGRAMS - 1))) oops()
#define CHECK_ELEMENT(gs,elem)      CHECK_RANGE(elem, 0, gs->globalGS->maxp->maxElements - 1)
#define CHECK_ELEMENTPTR(gs,p)      check_elementptr(gs,p)
#define CHECK_STORAGE(gs,n)         CHECK_RANGE(n, 0, gs->globalGS->maxp->maxStorage - 1)
#define CHECK_STACK(gs)             CHECK_RANGE(gs->stackPointer - gs->globalGS->stackBase, 0, gs->globalGS->maxp->maxStackElements - 1)
#define CHECK_POINT(gs,elem,pt)     check_point(gs,elem,pt)
#define CHECK_CONTOUR(gs,elem,ctr)  check_contour(gs,elem,ctr)
#define CHECK_STATE(gs)             check_state(gs);

/*lint +e506  Warning 506: Constant value Boolean */

#ifdef FS_TRACE
static char *opCodes[] =
{
    "SVTCA-Y",                /* 00 */
    "SVTCA-X",                /* 01 */
    "SPVTCA-Y",               /* 02 */
    "SPVTCA-x",               /* 03 */
    "SFVTCA-Y",               /* 04 */
    "SFVTCA-X",               /* 05 */
    "SPVTL-PAR",              /* 06 */
    "SPVTL-PER",              /* 07 */
    "SFVTL-PAR",              /* 08 */
    "SFVTL-PER",              /* 09 */
    "WPV",                    /* 0a */
    "WFV",                    /* 0b */
    "RPV",                    /* 0c */
    "RFV",                    /* 0d */
    "SFVTPV",                 /* 0e */
    "ISECT",                  /* 0f */
    "SRP0",                   /* 10 */
    "SRP1",                   /* 11 */
    "SRP2",                   /* 12 */
    "SZP0",                   /* 13 */
    "SZP1",                   /* 14 */
    "SZP2",                   /* 15 */
    "SZPS",                   /* 16 */
    "SLOOP",                  /* 17 */
    "RTG",                    /* 18 */
    "RTHG",                   /* 19 */
    "LMD",                    /* 1a */
    "ELSE",                   /* 1b */
    "JMPR",                   /* 1c */
    "SCVTCI",                 /* 1d */
    "LSWCI",                  /* 1e */
    "LSW",                    /* 1f */
    "DUP",                    /* 20 */
    "POP",                    /* 21 */
    "CLEAR",                  /* 22 */
    "SWAP",                   /* 23 */
    "DEPTH",                  /* 24 */
    "CINDEX",                 /* 25 */
    "MINDEX",                 /* 26 */
    "ALIGNPTS",               /* 27 */
    "RAW",                    /* 28 */
    "UTP",                    /* 29 */
    "LOOPCALL",               /* 2a */
    "CALL",                   /* 2b */
    "FDEF",                   /* 2c */
    "ENDF",                   /* 2d */
    "MDAP",                   /* 2e */
    "MDAP",                   /* 2f */
    "IUP-Y",                  /* 30 */
    "IUP-X",                  /* 31 */
    "SHP(rp2,zp1)",           /* 32 */
    "SHP(rp1,zp0)",           /* 33 */
    "SHC(rp2,zp1)",           /* 34 */
    "SHC(rp1,zp0)",           /* 35 */
    "SHZ(rp2,zp1)",           /* 36 */
    "SHZ(rp1,zp0)",           /* 37 */
    "SHPIX",                  /* 38 */
    "IP",                     /* 39 */
    "MSIRP",                  /* 3a */
    "MSIRP",                  /* 3b */
    "ALIGNRP",                /* 3c */
    "RTDG",                   /* 3d */
    "MIAP[0]",                /* 3e */
    "MIAP[1]",                /* 3f */
    "NPUSHB",                 /* 40 */
    "NPUSHW",                 /* 41 */
    "WS",                     /* 42 */
    "RS",                     /* 43 */
    "WCVT",                   /* 44 */
    "RCVT",                   /* 45 */
    "RC",                     /* 46 */
    "RC",                     /* 47 */
    "WC",                     /* 48 */
    "MD",                     /* 49 */
    "MD",                     /* 4a */
    "MPPEM",                  /* 4b */
    "MPS",                    /* 4c */
    "FLIPON",                 /* 4d */
    "FLIPOFF",                /* 4e */
    "DEBUG",                  /* 4f */
    "LT",                     /* 50 */
    "LTEQ",                   /* 51 */
    "GT",                     /* 52 */
    "GTEQ",                   /* 53 */
    "EQ",                     /* 54 */
    "NEQ",                    /* 55 */
    "ODD",                    /* 56 */
    "EVEN",                   /* 57 */
    "IF",                     /* 58 */
    "EIF",                    /* 59 */
    "AND",                    /* 5a */
    "OR",                     /* 5b */
    "NOT",                    /* 5c */
    "DELTAP1",                /* 5d */
    "SDB",                    /* 5e */
    "SDS",                    /* 5f */
    "ADD",                    /* 60 */
    "SUB",                    /* 61 */
    "DIV",                    /* 62 */
    "MUL",                    /* 63 */
    "ABS",                    /* 64 */
    "NEG",                    /* 65 */
    "FLOOR",                  /* 66 */
    "CEIL",                   /* 67 */
    "ROUND-G",                /* 68 */
    "ROUND-B",                /* 69 */
    "ROUND-W",                /* 6a */
    "ROUND-?",                /* 6b */
    "NROUND-G",               /* 6c */
    "NROUND-B",               /* 6d */
    "NROUND-W",               /* 6e */
    "NROUND-?",               /* 6f */
    "WCVTF",                  /* 70 */
    "DELTAP2",                /* 71 */
    "DELTAP3",                /* 72 */
    "DELTAC1",                /* 73 */
    "DELTAC2",                /* 74 */
    "DELTAC3",                /* 75 */
    "SROUND",                 /* 76 */
    "S45ROUND",               /* 77 */
    "JROT",                   /* 78 */
    "JROF",                   /* 79 */
    "ROFF",                   /* 7a */
    "IllegalInstruction",     /* 7b */
    "RUTG",                   /* 7c */
    "RDTG",                   /* 7d */
    "SANGW",                  /* 7e */
    "AA",                     /* 7f */
    "FLIPPT",                 /* 80 */
    "FLIPRGON",               /* 81 */
    "FLIPRGOFF",              /* 82 */
    "IDefPatch",              /* 83 */
    "IDefPatch",              /* 84 */
    "SCANCTRL",               /* 85 */
    "SDPVTL",                 /* 86 */
    "SDPVTL",                 /* 87 */
    "GETINFO",                /* 88 */
    "IDEF",                   /* 89 */
    "ROTATE",                 /* 8a */
    "MAX",                    /* 8b */
    "MIN",                    /* 8c */
    "SCANTYPE",               /* 8d */
    "INSTCTRL",               /* 8e */
    "IDefPatch",              /* 8f */
    "IDefPatch",              /* 90 */
    "IDefPatch",              /* 91 */
    "IDefPatch",              /* 92 */
    "IDefPatch",              /* 93 */
    "IDefPatch",              /* 94 */
    "IDefPatch",              /* 95 */
    "IDefPatch",              /* 96 */
    "IDefPatch",              /* 97 */
    "IDefPatch",              /* 98 */
    "IDefPatch",              /* 99 */
    "IDefPatch",              /* 9a */
    "IDefPatch",              /* 9b */
    "IDefPatch",              /* 9c */
    "IDefPatch",              /* 9d */
    "IDefPatch",              /* 9e */
    "IDefPatch",              /* 9f */
    "IDefPatch",              /* a0 */
    "IDefPatch",              /* a1 */
    "MAZDELTA1",              /* a2 */
    "MAZDELTA2",              /* a3 */
    "MAZDELTA3",              /* a4 */
    "MAZMODE",                /* a5 */
    "MAZSTROKE",              /* a6 */
    "DELTAK1",                /* a7 */
    "DELTAK2",                /* a8 */
    "DELTAK3",                /* a9 */
    "DELTAL1",                /* aa */
    "DELTAL2",                /* ab */
    "DELTAL3",                /* ac */
    "DELTAS1",                /* ad */
    "DELTAS2",                /* ae */
    "DELTAS3",                /* af */
    "PUSHB[000]",             /* b0 */
    "PUSHB[001]",             /* b1 */
    "PUSHB[010]",             /* b2 */
    "PUSHB[011]",             /* b3 */
    "PUSHB[100]",             /* b4 */
    "PUSHB[101]",             /* b5 */
    "PUSHB[110]",             /* b6 */
    "PUSHB[111]",             /* b7 */
    "PUSHW[000]",             /* b8 */
    "PUSHW[001]",             /* b9 */
    "PUSHW[010]",             /* ba */
    "PUSHW[011]",             /* bb */
    "PUSHW[100]",             /* bc */
    "PUSHW[101]",             /* bd */
    "PUSHW[110]",             /* be */
    "PUSHW[111]",             /* bf */
    "MDRP[00000]",            /* c0 */
    "MDRP]00001]",            /* c1 */
    "MDRP[00010]",            /* c2 */
    "MDRP[00011]",            /* c3 */
    "MDRP[00100]",            /* c4 */
    "MDRP[00101]",            /* c5 */
    "MDRP[00110]",            /* c6 */
    "MDRP[00111]",            /* c7 */
    "MDRP[01000]",            /* c8 */
    "MDRP[01001]",            /* c9 */
    "MDRP[01010]",            /* ca */
    "MDRP[01011]",            /* cb */
    "MDRP[01100]",            /* cc */
    "MDRP[01101]",            /* cd */
    "MDRP[01110]",            /* ce */
    "MDRP[01111]",            /* cf */
    "MDRP[10000]",            /* d0 */
    "MDRP[10001]",            /* d1 */
    "MDRP[10010]",            /* d2 */
    "MDRP[10011]",            /* d3 */
    "MDRP[10100]",            /* d4 */
    "MDRP[10101]",            /* d5 */
    "MDRP[10110]",            /* d6 */
    "MDRP[10111]",            /* d7 */
    "MDRP[11000]",            /* d8 */
    "MDRP[11001]",            /* d9 */
    "MDRP[11010]",            /* da */
    "MDRP[11011]",            /* db */
    "MDRP[11100]",            /* dc */
    "MDRP[11101]",            /* dd */
    "MDRP[11110]",            /* de */
    "MDRP[11111]",            /* df */
    "MIRP[00000]",            /* e0 */
    "MIRP]00001]",            /* e1 */
    "MIRP[00010]",            /* e2 */
    "MIRP[00011]",            /* e3 */
    "MIRP[00100]",            /* e4 */
    "MIRP[00101]",            /* e5 */
    "MIRP[00110]",            /* e6 */
    "MIRP[00111]",            /* e7 */
    "MIRP[01000]",            /* e8 */
    "MIRP[01001]",            /* e9 */
    "MIRP[01010]",            /* ea */
    "MIRP[01011]",            /* eb */
    "MIRP[01100]",            /* ec */
    "MIRP[01101]",            /* ed */
    "MIRP[01110]",            /* ee */
    "MIRP[01111]",            /* ef */
    "MIRP[10000]",            /* f0 */
    "MIRP[10001]",            /* f1 */
    "MIRP[10010]",            /* f2 */
    "MIRP[10011]",            /* f3 */
    "MIRP[10100]",            /* f4 */
    "MIRP[10101]",            /* f5 */
    "MIRP[10110]",            /* f6 */
    "MIRP[10111]",            /* f7 */
    "MIRP[11000]",            /* f8 */
    "MIRP[11001]",            /* f9 */
    "MIRP[11010]",            /* fa */
    "MIRP[11011]",            /* fb */
    "MIRP[11100]",            /* fc */
    "MIRP[11101]",            /* fd */
    "MIRP[11110]",            /* fe */
    "MIRP[11111]",            /* ff */
};

FS_VOID indent_fn()
{
    int n = indent_is;
    while (n--)
        fputc('\t', stdout);
}

FS_VOID trace_fn1(fnt_LocalGraphicStateType *gs)
{
    F26DOT6 *x, *y, *ox, *oy;
    FS_LONG *oox, *ooy;
    FS_USHORT *sp, *ep;
    FS_SHORT i, k, nc;
    FS_LONG  j;

    indent_fn();
    if ( (gs->opCode >= 0xA2) && (gs->opCode <= 0xAf) )
    {
        if (gs->globalGS->udFuncType == ITYPE_UD_FUNCTIONS)
            FS_PRINTF(("\nbefore opcode=%02x %s\n", gs->opCode, opCodes[gs->opCode]))
        else
            FS_PRINTF(("\nbefore opcode=%02x %s\n", gs->opCode, "IDefPatch"));
    }
    else
        FS_PRINTF(("\nbefore opcode=%02x %s\n", gs->opCode, opCodes[gs->opCode]));

    /* show the stack as integers and F26DOT6 */
    j = gs->stackPointer - gs->globalGS->stackBase;
    if (j > 10)
        j = 10;
    indent_fn();
    FS_PRINTF(("stack: "));
    for (i = 1; i <= j; i++)
    {
        FS_PRINTF(("%9ld ", gs->stackPointer[-i]));
    }
    FS_PRINTF(("\n"));
    indent_fn();
    FS_PRINTF(("        "));
    for (i = 1; i <= j; i++)
    {
        FS_PRINTF(("%9.3f ", gs->stackPointer[-i] / 64.0));
    }
    FS_PRINTF(("\n"));

    indent_fn();
    FS_PRINTF(("rp0=%ld rp1=%ld rp2=%ld\n", gs->Pt0, gs->Pt1, gs->Pt2));
    indent_fn();
    FS_PRINTF(("zp0=%d zp1=%d zp2=%d\n",
               (int)(gs->CE0 - gs->elements),
               (int)(gs->CE1 - gs->elements),
               (int)(gs->CE2 - gs->elements)));
    indent_fn();
    FS_PRINTF(("free = %7.3f %7.3f\n", gs->freedom.x / 16384.0, gs->freedom.y / 16384.0));
    indent_fn();
    FS_PRINTF(("proj = %7.3f %7.3f\n", gs->proj.x / 16384.0, gs->proj.y / 16384.0));
    indent_fn();
    FS_PRINTF(("loop = %ld\n", gs->loop));

    for (k = 0; k < 2; k++)
    {
        fnt_ElementType *elem = gs->elements + k;

        indent_fn();
        FS_PRINTF(("element %d\n", k));

        if (elem->nc > 0)
        {
            x = elem->x;
            y = elem->y;
            ox = elem->ox;
            oy = elem->oy;
            oox = elem->oox;
            ooy = elem->ooy;
            sp = elem->sp;
            ep = elem->ep;
            nc = elem->nc;

            indent_fn();
            FS_PRINTF(("nc=%d\n", nc));

            indent_fn();
            FS_PRINTF(("sp[] = "));
            for (i = 0; i < nc; i++)
                FS_PRINTF(("%3d ", sp[i]));
            FS_PRINTF(("\n"));

            indent_fn();
            FS_PRINTF(("ep[] = "));
            for (i = 0; i < nc; i++)
                FS_PRINTF(("%3d ", ep[i]));
            FS_PRINTF(("\n"));

            for (i = 0; i < nc; i++)
            {
                for (j = sp[i]; j <= ep[i]; j++)
                {
                    indent_fn();
                    FS_PRINTF(("%3ld: %7.3f  %7.3f | ", j, x[j] / 64.0, y[j] / 64.0));
                    indent_fn();
                    FS_PRINTF((" %7.3f  %7.3f | ", ox[j] / 64.0, oy[j] / 64.0));
                    indent_fn();
                    FS_PRINTF((" %7ld  %7ld \n", oox[j], ooy[j]));
                }
                indent_fn();
                FS_PRINTF(("%3d: %7.3f  %7.3f | ", sp[i], x[sp[i]] / 64.0, y[sp[i]] / 64.0));
                indent_fn();
                FS_PRINTF((" %7.3f  %7.3f | ", ox[sp[i]] / 64.0, oy[sp[i]] / 64.0));
                indent_fn();
                FS_PRINTF((" %7ld  %7ld\n", oox[sp[i]], ooy[sp[i]]));
            }

            if (k == 1)
            {
                /* phantoms */
                indent_fn();
                FS_PRINTF(("phantoms\n"));
                for (j = ep[nc - 1] + 1; j < ep[nc - 1] + 1 + PHANTOMCOUNT; j++)
                {
                    indent_fn();
                    FS_PRINTF(("%3ld: %7.3f  %7.3f | ", j, x[j] / 64.0, y[j] / 64.0));
                    indent_fn();
                    FS_PRINTF((" %7.3f  %7.3f | ", ox[j] / 64.0, oy[j] / 64.0));
                    indent_fn();
                    FS_PRINTF((" %7ld  %7ld \n", oox[j], ooy[j]));
                }
            }
        }
    }
}

FS_VOID trace_fn2(fnt_LocalGraphicStateType *gs)
{
    F26DOT6 *x, *y, *ox, *oy;
    FS_LONG *oox, *ooy;
    FS_USHORT *sp, *ep;
    FS_SHORT i, k, nc;
    FS_LONG  j;

    indent_fn();
    FS_PRINTF(("\nafter\n"));

    /* show the stack as integers and F26DOT6 */
    j = gs->stackPointer - gs->globalGS->stackBase;
    if (j > 10)
        j = 10;
    indent_fn();
    FS_PRINTF(("stack: "));
    for (i = 1; i <= j; i++)
    {
        FS_PRINTF(("%9ld ", gs->stackPointer[-i]));
    }
    FS_PRINTF(("\n"));
    indent_fn();
    FS_PRINTF(("        "));
    for (i = 1; i <= j; i++)
    {
        FS_PRINTF(("%9.3f ", gs->stackPointer[-i] / 64.0));
    }
    FS_PRINTF(("\n"));

    indent_fn();
    FS_PRINTF(("rp0=%ld rp1=%ld rp2=%ld\n", gs->Pt0, gs->Pt1, gs->Pt2));
    indent_fn();
    FS_PRINTF(("zp0=%d zp1=%d zp2=%d\n",
               (int)(gs->CE0 - gs->elements),
               (int)(gs->CE1 - gs->elements),
               (int)(gs->CE2 - gs->elements)));
    indent_fn();
    FS_PRINTF(("free = %7.3f %7.3f\n", gs->freedom.x / 16384.0, gs->freedom.y / 16384.0));
    indent_fn();
    FS_PRINTF(("proj = %7.3f %7.3f\n", gs->proj.x / 16384.0, gs->proj.y / 16384.0));
    indent_fn();
    FS_PRINTF(("loop = %ld\n", gs->loop));

    for (k = 0; k < 2; k++)
    {
        fnt_ElementType *elem = gs->elements + k;

        indent_fn();
        FS_PRINTF(("element %d\n", k));

        if (elem->nc > 0)
        {
            x = elem->x;
            y = elem->y;
            ox = elem->ox;
            oy = elem->oy;
            oox = elem->oox;
            ooy = elem->ooy;
            sp = elem->sp;
            ep = elem->ep;
            nc = elem->nc;

            indent_fn();
            FS_PRINTF(("nc=%d\n", nc));

            indent_fn();
            FS_PRINTF(("sp[] = "));
            for (i = 0; i < nc; i++)
                FS_PRINTF(("%3d ", sp[i]));
            FS_PRINTF(("\n"));

            indent_fn();
            FS_PRINTF(("ep[] = "));
            for (i = 0; i < nc; i++)
                FS_PRINTF(("%3d ", ep[i]));
            FS_PRINTF(("\n"));

            for (i = 0; i < nc; i++)
            {
                for (j = sp[i]; j <= ep[i]; j++)
                {
                    indent_fn();
                    FS_PRINTF(("%3ld: %7.3f  %7.3f | ", j, x[j] / 64.0, y[j] / 64.0));
                    indent_fn();
                    FS_PRINTF((" %7.3f  %7.3f | ", ox[j] / 64.0, oy[j] / 64.0));
                    indent_fn();
                    FS_PRINTF((" %7ld  %7ld \n", oox[j], ooy[j]));
                }
                indent_fn();
                FS_PRINTF(("%3d: %7.3f  %7.3f | ", sp[i], x[sp[i]] / 64.0, y[sp[i]] / 64.0));
                indent_fn();
                FS_PRINTF((" %7.3f  %7.3f | ", ox[sp[i]] / 64.0, oy[sp[i]] / 64.0));
                indent_fn();
                FS_PRINTF((" %7ld  %7ld\n", oox[sp[i]], ooy[sp[i]]));
            }

            if (k == 1)
            {
                /* phantoms */
                indent_fn();
                FS_PRINTF(("phantoms\n"));
                for (j = ep[nc - 1] + 1; j < ep[nc - 1] + 1 + PHANTOMCOUNT; j++)
                {
                    indent_fn();
                    FS_PRINTF(("%3ld: %7.3f  %7.3f | ", j, x[j] / 64.0, y[j] / 64.0));
                    indent_fn();
                    FS_PRINTF((" %7.3f  %7.3f | ", ox[j] / 64.0, oy[j] / 64.0));
                    indent_fn();
                    FS_PRINTF((" %7ld  %7ld \n", oox[j], ooy[j]));
                }
            }
        }
    }
}
#endif /* FS_TRACE */

/*lint -e522 Warning -- Highest operation, function 'oops', lacks side-effects     */
/*lint -e438 Warning -- Last value assigned to variable 'a' not used               */

FS_VOID oops(FS_VOID_ARGS)
{
    int a = 0, b;
    /* set a breakpoint here when debugging */
    b = a;
    a = b;
    return;
}
/*lint +e438 Warning -- Last value assigned to variable 'a' not used               */

FS_VOID check_elementptr(fnt_LocalGraphicStateType* gs, fnt_ElementType* elem)
{
    if (elem == &gs->elements[1])
    {
        int maxctrs, maxpts;

        maxctrs = MAX(gs->globalGS->maxp->maxContours, gs->globalGS->maxp->maxCompositeContours);
        maxpts  = MAX(gs->globalGS->maxp->maxPoints, gs->globalGS->maxp->maxCompositePoints);

        CHECK_RANGE(elem->nc, 1, maxctrs);
        CHECK_RANGE(elem->ep[elem->nc - 1], 0, maxpts - 1);
    }
    else if (elem != &gs->elements[0])
        oops();
}

FS_VOID check_point(fnt_LocalGraphicStateType* gs, fnt_ElementType* elem, int pt)
{
    CHECK_ELEMENTPTR(gs, elem);
    if (gs->elements == elem)
    {
        CHECK_RANGE(pt, 0, gs->globalGS->maxp->maxTwilightPoints - 1);
    }
    else
    {
        CHECK_RANGE(pt, 0, elem->ep[elem->nc - 1] + PHANTOMCOUNT);  /* phantom points */
    }
}


FS_VOID check_contour(fnt_LocalGraphicStateType* gs, fnt_ElementType* elem, int ctr)
{
    CHECK_ELEMENTPTR(gs, elem);
    CHECK_RANGE(ctr, 0, elem->nc - 1);
}

#define LIMIT        (65536L*64L)
FS_VOID check_state( fnt_LocalGraphicStateType *gs )
{
    fnt_ElementType* elem;
    F26DOT6* x;
    F26DOT6* y;
    FS_SHORT count;
    F26DOT6 xmin, xmax, ymin, ymax;

    if (!gs->globalGS->glyphProgram) return;

    elem = &gs->elements[1];
    x = elem->x;
    y = elem->y;
    count = elem->nc ? elem->ep[elem->nc - 1] : 0;
    xmin = xmax = *x;
    ymin = ymax = *y;

    for (; count >= 0; --count)
    {
        if (*x < xmin)
            xmin = *x;
        else if (*x > xmax)
            xmax = *x;
        if (*y < ymin)
            ymin = *y;
        else if (*y > ymax)
            ymax = *y;
        x++, y++;
    }
    if (xmin < -LIMIT || xmax > LIMIT || ymin < -LIMIT || ymax > LIMIT)
        oops();
}

static F26DOT6 fnt_Nil_gsGetCVTEntry(struct fnt_LocalGraphicStateType *gs, FS_LONG n)
{
    (void)gs; /* unused */
    (void)n; /* unused */

    oops();
    return 0;
}

static F26DOT6 fnt_Nil_gsGetSingleWidth (struct fnt_LocalGraphicStateType *gs)
{
    (void)gs; /* unused */

    oops();
    return 0;
}


#else   /* !FS_DEBUG */
#define CHECK_RANGE(a,b,c)
#define CHECK_ASSERTION(a)
#define CHECK_CVT(a,b)
#define CHECK_POINT(a,b,c)
#define CHECK_CONTOUR(a,b,c)
#define CHECK_FDEF(a,b)
#define CHECK_PROGRAM(a)
#define CHECK_ELEMENT(a,b)
#define CHECK_STORAGE(a,b)
#define CHECK_STACK(a)
#define CHECK_STATE(gs)

#endif  /* FS_DEBUG */


#define CHECK_POP(gs, s)        POP(s)
#define CHECK_PUSH(gs, s, v)    PUSH(s, v)

#define GETBYTE(ptr)    ( (FS_BYTE)*ptr++ )

#define BIT0( t ) ( (t) & 0x01 )
/*#define BIT1( t ) ( (t) & 0x02 )    not used as of now*/
#define BIT2( t ) ( (t) & 0x04 )
#define BIT3( t ) ( (t) & 0x08 )
#define BIT4( t ) ( (t) & 0x10 )
/*#define BIT5( t ) ( (t) & 0x20 )
#define BIT6( t ) ( (t) & 0x40 )
#define BIT7( t ) ( (t) & 0x80 )     not used as of now*/

/******** 12 BinaryOperators **********/
#define LT_CODE         0x50
#define LTEQ_CODE       0x51
#define GT_CODE         0x52
#define GTEQ_CODE       0x53
#define EQ_CODE         0x54
#define NEQ_CODE        0x55
#define AND_CODE        0x5A
#define OR_CODE         0x5B
#define ADD_CODE        0x60
#define SUB_CODE        0x61
#define DIV_CODE        0x62
#define MUL_CODE        0x63
#define MAX_CODE        0x8b
#define MIN_CODE        0x8c

/******** 9 UnaryOperators **********/
#define ODD_CODE        0x56
#define EVEN_CODE       0x57
#define NOT_CODE        0x5C
#define ABS_CODE        0x64
#define NEG_CODE        0x65
#define FLOOR_CODE      0x66
#define CEILING_CODE    0x67

/******** 6 RoundState Codes **********/
#define RTG_CODE        0x18
#define RTHG_CODE       0x19
#define RTDG_CODE       0x3D
#define ROFF_CODE       0x7A
#define RUTG_CODE       0x7C
#define RDTG_CODE       0x7D

/****** LocalGS Codes *********/
#define POP_CODE        0x21
#define SRP0_CODE       0x10
#define SRP1_CODE       0x11
#define SRP2_CODE       0x12
#define LLOOP_CODE      0x17

/****** Element Codes *********/
#define SCE0_CODE       0x13
#define SCE1_CODE       0x14
#define SCE2_CODE       0x15
#define SCES_CODE       0x16

/****** Control Codes *********/
#define IF_CODE         0x58
#define ELSE_CODE       0x1B
#define EIF_CODE        0x59
#define ENDF_CODE       0x2d
#define MD_CODE         0x49

/***** Push/Skip Codes *****/
#define NPUSHB_CODE     0x40
#define NPUSHW_CODE     0x41

#define PUSHB_START     0xb0
#define PUSHB_END       0xb7
#define PUSHW_START     0xb8
#define PUSHW_END       0xbf

/* flags for UTP, IUP, MovePoint */
#define XMOVED          0x01
#define YMOVED          0x02

/* used by fnt_SetRoundState() */
#define FRACSQRT2DIV2 759250125L

/* Private function prototypes */
#ifndef KILL_SETJMP_LONGJMP
static FS_VOID fnt_Panic(fnt_LocalGraphicStateType *gs, int error);
#endif

static FS_VOID fnt_IllegalInstruction(fnt_LocalGraphicStateType *gs);
static FS_VOID fnt_Normalize(F26DOT6 x, F26DOT6 y, SHORT_UNIT_VECTOR *v);
static FS_VOID fnt_MovePoint(fnt_LocalGraphicStateType *gs, fnt_ElementType *element, FS_LONG point, F26DOT6 delta);
static FS_VOID fnt_XMovePoint(fnt_LocalGraphicStateType *gs, fnt_ElementType *element, FS_LONG point, F26DOT6 delta) ;
static FS_VOID fnt_YMovePoint(fnt_LocalGraphicStateType *gs, fnt_ElementType *element, FS_LONG point, F26DOT6 delta) ;
static F26DOT6 fnt_Project(fnt_LocalGraphicStateType *gs, F26DOT6 x, F26DOT6 y);
static F26DOT6 fnt_OldProject(fnt_LocalGraphicStateType *gs, F26DOT6 x, F26DOT6 y);
static F26DOT6 fnt_XProject(fnt_LocalGraphicStateType *gs, F26DOT6 x, F26DOT6 y);
static F26DOT6 fnt_YProject(fnt_LocalGraphicStateType *gs, F26DOT6 x, F26DOT6 y);
static FS_FIXED fnt_GetCVTScale(fnt_LocalGraphicStateType *gs);
static F26DOT6 fnt_GetCVTEntryFast(fnt_LocalGraphicStateType *gs, FS_LONG n);
static F26DOT6 fnt_GetCVTEntrySlow(fnt_LocalGraphicStateType *gs, FS_LONG n);
static F26DOT6 fnt_GetSingleWidthFast(fnt_LocalGraphicStateType *gs);
static F26DOT6 fnt_GetSingleWidthSlow(fnt_LocalGraphicStateType *gs);
static FS_VOID fnt_ChangeCvt(fnt_LocalGraphicStateType *gs, fnt_ElementType *element, FS_LONG number, F26DOT6 delta);
static FS_VOID fnt_InnerExecute(fnt_LocalGraphicStateType *gs, FS_BYTE *ptr, FS_BYTE *eptr);
static FS_VOID fnt_Check_PF_Proj(fnt_LocalGraphicStateType *gs);
static FS_VOID fnt_ComputeAndCheck_PF_Proj(fnt_LocalGraphicStateType *gs);
static FS_VOID fnt_SetRoundValues(fnt_LocalGraphicStateType *gs, int arg1, int normalRound);
static F26DOT6 fnt_CheckSingleWidth(F26DOT6 value, fnt_LocalGraphicStateType *gs);
static fnt_instrDef* fnt_FindIDef(fnt_LocalGraphicStateType* gs, FS_BYTE opCode);
static FS_VOID fnt_DeltaEngine(fnt_LocalGraphicStateType *gs, FntMoveFunc doIt, FS_SHORT base, FS_SHORT shift);

#ifdef FS_EDGE_HINTS
static FS_VOID do_deltas_250(fnt_LocalGraphicStateType *gs);
static FS_VOID do_deltas_251(fnt_LocalGraphicStateType *gs);
#endif

static FS_VOID do_deltas_252(fnt_LocalGraphicStateType *gs);
static FS_VOID do_deltas_253(fnt_LocalGraphicStateType *gs);
static FS_VOID fnt_DeltaMAZEngine(fnt_LocalGraphicStateType *gs, FS_SHORT base, FS_SHORT shift);

/* Actual instructions for the jump table */
static FS_VOID fnt_SVTCA_0(fnt_LocalGraphicStateType *gs);
static FS_VOID fnt_SVTCA_1(fnt_LocalGraphicStateType *gs);
static FS_VOID fnt_SPVTCA(fnt_LocalGraphicStateType *gs);
static FS_VOID fnt_SFVTCA(fnt_LocalGraphicStateType *gs);
static FS_VOID fnt_SPVTL(fnt_LocalGraphicStateType *gs);
static FS_VOID fnt_SDPVTL(fnt_LocalGraphicStateType *gs);
static FS_VOID fnt_SFVTL(fnt_LocalGraphicStateType *gs);
static FS_VOID fnt_WPV(fnt_LocalGraphicStateType *gs);
static FS_VOID fnt_WFV(fnt_LocalGraphicStateType *gs);
static FS_VOID fnt_RPV(fnt_LocalGraphicStateType *gs);
static FS_VOID fnt_RFV(fnt_LocalGraphicStateType *gs);
static FS_VOID fnt_SFVTPV(fnt_LocalGraphicStateType *gs);
static FS_VOID fnt_ISECT(fnt_LocalGraphicStateType *gs);
static FS_VOID fnt_SetLocalGraphicState(fnt_LocalGraphicStateType *gs);
static FS_VOID fnt_SetElementPtr(fnt_LocalGraphicStateType *gs);
static FS_VOID fnt_SetRoundState(fnt_LocalGraphicStateType *gs);
static FS_VOID fnt_SROUND(fnt_LocalGraphicStateType *gs);
static FS_VOID fnt_S45ROUND(fnt_LocalGraphicStateType *gs);
static FS_VOID fnt_LMD(fnt_LocalGraphicStateType *gs);
static FS_VOID fnt_RAW(fnt_LocalGraphicStateType *gs);
static FS_VOID fnt_LWTCI(fnt_LocalGraphicStateType *gs);
static FS_VOID fnt_LSWCI(fnt_LocalGraphicStateType *gs);
static FS_VOID fnt_LSW(fnt_LocalGraphicStateType *gs);
static FS_VOID fnt_DUP(fnt_LocalGraphicStateType *gs);
static FS_VOID fnt_CLEAR(fnt_LocalGraphicStateType *gs);
static FS_VOID fnt_SWAP(fnt_LocalGraphicStateType *gs);
static FS_VOID fnt_DEPTH(fnt_LocalGraphicStateType *gs);
static FS_VOID fnt_CINDEX(fnt_LocalGraphicStateType *gs);
static FS_VOID fnt_MINDEX(fnt_LocalGraphicStateType *gs);
static FS_VOID fnt_ROTATE( fnt_LocalGraphicStateType* gs );
static FS_VOID fnt_MDAP(fnt_LocalGraphicStateType *gs);
static FS_VOID fnt_MIAP(fnt_LocalGraphicStateType *gs);
/*static*/
FS_VOID fnt_IUP(fnt_LocalGraphicStateType *gs);
static FS_VOID fnt_SHP(fnt_LocalGraphicStateType *gs);
static FS_VOID fnt_SHC(fnt_LocalGraphicStateType *gs);
static FS_VOID fnt_SHE(fnt_LocalGraphicStateType *gs);
static FS_VOID fnt_SHPIX(fnt_LocalGraphicStateType *gs);
static FS_VOID fnt_IP(fnt_LocalGraphicStateType *gs);
static FS_VOID fnt_MSIRP(fnt_LocalGraphicStateType *gs);
static FS_VOID fnt_ALIGNRP(fnt_LocalGraphicStateType *gs);
static FS_VOID fnt_ALIGNPTS(fnt_LocalGraphicStateType *gs);
static FS_VOID fnt_SANGW(fnt_LocalGraphicStateType *gs);
static FS_VOID fnt_FLIPPT(fnt_LocalGraphicStateType *gs);
static FS_VOID fnt_FLIPRGON(fnt_LocalGraphicStateType *gs);
static FS_VOID fnt_FLIPRGOFF(fnt_LocalGraphicStateType *gs);
static FS_VOID fnt_SCANCTRL(fnt_LocalGraphicStateType *gs);
static FS_VOID fnt_SCANTYPE(fnt_LocalGraphicStateType *gs);
static FS_VOID fnt_INSTCTRL(fnt_LocalGraphicStateType *gs);
static FS_VOID fnt_AA(fnt_LocalGraphicStateType *gs);
static FS_VOID fnt_NPUSHB(fnt_LocalGraphicStateType *gs);
static FS_VOID fnt_NPUSHW(fnt_LocalGraphicStateType *gs);
static FS_VOID fnt_WS(fnt_LocalGraphicStateType *gs);
static FS_VOID fnt_RS(fnt_LocalGraphicStateType *gs);
static FS_VOID fnt_WCVT(fnt_LocalGraphicStateType *gs);
static FS_VOID fnt_WCVTFOD(fnt_LocalGraphicStateType *gs);
static FS_VOID fnt_RCVT(fnt_LocalGraphicStateType *gs);
static FS_VOID fnt_RC(fnt_LocalGraphicStateType *gs);
static FS_VOID fnt_WC(fnt_LocalGraphicStateType *gs);
static FS_VOID fnt_MD(fnt_LocalGraphicStateType *gs);
static FS_VOID fnt_MPPEM(fnt_LocalGraphicStateType *gs);
static FS_VOID fnt_MPS(fnt_LocalGraphicStateType *gs);
static FS_VOID fnt_GETINFO(fnt_LocalGraphicStateType* gs);
static FS_VOID fnt_FLIPON(fnt_LocalGraphicStateType *gs);
static FS_VOID fnt_FLIPOFF(fnt_LocalGraphicStateType *gs);
static FS_VOID fnt_DEBUG(fnt_LocalGraphicStateType *gs);
static FS_VOID fnt_SkipPushCrap(fnt_LocalGraphicStateType *gs);
static FS_VOID fnt_IF(fnt_LocalGraphicStateType *gs);
static FS_VOID fnt_ELSE( fnt_LocalGraphicStateType* gs );
static FS_VOID fnt_EIF(fnt_LocalGraphicStateType *gs);
static FS_VOID fnt_JMPR( fnt_LocalGraphicStateType* gs );
static FS_VOID fnt_JROT(fnt_LocalGraphicStateType *gs);
static FS_VOID fnt_JROF(fnt_LocalGraphicStateType *gs);
static FS_VOID fnt_BinaryOperand(fnt_LocalGraphicStateType*);
static FS_VOID fnt_UnaryOperand(fnt_LocalGraphicStateType*);
static FS_VOID fnt_ROUND(fnt_LocalGraphicStateType *gs);
static FS_VOID fnt_NROUND(fnt_LocalGraphicStateType *gs);
static FS_VOID fnt_PUSHB(fnt_LocalGraphicStateType *gs);
static FS_VOID fnt_PUSHW(fnt_LocalGraphicStateType *gs);
static FS_VOID fnt_MDRP(fnt_LocalGraphicStateType *gs);
static FS_VOID fnt_MIRP(fnt_LocalGraphicStateType *gs);
static FS_VOID fnt_CALL(fnt_LocalGraphicStateType *gs);
static FS_VOID fnt_FDEF(fnt_LocalGraphicStateType *gs);
static FS_VOID fnt_LOOPCALL(fnt_LocalGraphicStateType *gs);
static FS_VOID fnt_IDefPatch( fnt_LocalGraphicStateType* gs );
static FS_VOID fnt_IDEF( fnt_LocalGraphicStateType* gs );
static FS_VOID fnt_UTP(fnt_LocalGraphicStateType *gs);
static FS_VOID fnt_SDB(fnt_LocalGraphicStateType *gs);
static FS_VOID fnt_SDS(fnt_LocalGraphicStateType *gs);
static FS_VOID fnt_DELTAP1(fnt_LocalGraphicStateType *gs);
static FS_VOID fnt_DELTAP2(fnt_LocalGraphicStateType *gs);
static FS_VOID fnt_DELTAP3(fnt_LocalGraphicStateType *gs);
static FS_VOID fnt_DELTAC1(fnt_LocalGraphicStateType *gs);
static FS_VOID fnt_DELTAC2(fnt_LocalGraphicStateType *gs);
static FS_VOID fnt_DELTAC3(fnt_LocalGraphicStateType *gs);

static FS_VOID fnt_MAZDELTA1(fnt_LocalGraphicStateType *gs);
static FS_VOID fnt_MAZDELTA2(fnt_LocalGraphicStateType *gs);
static FS_VOID fnt_MAZDELTA3(fnt_LocalGraphicStateType *gs);
static FS_VOID fnt_MAZMODE(fnt_LocalGraphicStateType *gs);
static FS_VOID fnt_MAZSTROKE(fnt_LocalGraphicStateType *gs);

static FS_VOID fnt_DELTAK1(fnt_LocalGraphicStateType *gs);
static FS_VOID fnt_DELTAK2(fnt_LocalGraphicStateType *gs);
static FS_VOID fnt_DELTAK3(fnt_LocalGraphicStateType *gs);
static FS_VOID fnt_DELTAL1(fnt_LocalGraphicStateType *gs);
static FS_VOID fnt_DELTAL2(fnt_LocalGraphicStateType *gs);
static FS_VOID fnt_DELTAL3(fnt_LocalGraphicStateType *gs);
static FS_VOID fnt_DELTAS1(fnt_LocalGraphicStateType *gs);
static FS_VOID fnt_DELTAS2(fnt_LocalGraphicStateType *gs);
static FS_VOID fnt_DELTAS3(fnt_LocalGraphicStateType *gs);


/*
 *  Function Table
 */
#ifndef GLOBAL_STATIC_FUNCTION_PTRS_OK

#define FntFuncI(v) *pff = (FntFunc)v; pff++;
#define FntFuncII(v) (FntFunc)v 

FntFunc interpFunc[MAXBYTE_INSTRUCTIONS];

FS_VOID fnt_initInterpFuncs( FS_VOID )
{
    FntFunc *pff = (FntFunc *)interpFunc;

    /* only need to do this once. */
    if (*pff == NULL)

#else

#define FntFuncI(v) (FntFunc)v,
#define FntFuncII(v) (FntFunc)v 

FntFunc interpFunc[MAXBYTE_INSTRUCTIONS] =

#endif
        /*lint -e{525} suppress "Negative indentation" */
    {
        FntFuncI(fnt_SVTCA_0) FntFuncI(fnt_SVTCA_1) FntFuncI(fnt_SPVTCA) FntFuncI(fnt_SPVTCA)
        FntFuncI(fnt_SFVTCA) FntFuncI(fnt_SFVTCA) FntFuncI(fnt_SPVTL) FntFuncI(fnt_SPVTL)
        FntFuncI(fnt_SFVTL) FntFuncI(fnt_SFVTL) FntFuncI(fnt_WPV) FntFuncI(fnt_WFV)
        FntFuncI(fnt_RPV) FntFuncI(fnt_RFV) FntFuncI(fnt_SFVTPV) FntFuncI(fnt_ISECT)
        FntFuncI(fnt_SetLocalGraphicState) FntFuncI(fnt_SetLocalGraphicState) /* SRP0 SRP1 */
        FntFuncI(fnt_SetLocalGraphicState)                        /* SRP2 */
        FntFuncI(fnt_SetElementPtr) FntFuncI(fnt_SetElementPtr)   /* SCE0 SCE1 */
        FntFuncI(fnt_SetElementPtr) FntFuncI(fnt_SetElementPtr)   /* SCE2 SCES */
        FntFuncI(fnt_SetLocalGraphicState)                        /* LLOOP     */
        FntFuncI(fnt_SetRoundState) FntFuncI(fnt_SetRoundState)   /* RTG RTHG  */
        FntFuncI(fnt_LMD) FntFuncI(fnt_ELSE) FntFuncI(fnt_JMPR)
        FntFuncI(fnt_LWTCI) FntFuncI(fnt_LSWCI) FntFuncI(fnt_LSW)
        FntFuncI(fnt_DUP) FntFuncI(fnt_SetLocalGraphicState)        /* DUP POP   */
        FntFuncI(fnt_CLEAR) FntFuncI(fnt_SWAP)
        FntFuncI(fnt_DEPTH) FntFuncI(fnt_CINDEX) FntFuncI(fnt_MINDEX) FntFuncI(fnt_ALIGNPTS)
        FntFuncI(fnt_RAW) FntFuncI(fnt_UTP) FntFuncI(fnt_LOOPCALL) FntFuncI(fnt_CALL)
        FntFuncI(fnt_FDEF) FntFuncI(fnt_IllegalInstruction)    /* ENDF; used for FDEF & IDEF */
        FntFuncI(fnt_MDAP) FntFuncI(fnt_MDAP)
        FntFuncI(fnt_IUP) FntFuncI(fnt_IUP) FntFuncI(fnt_SHP) FntFuncI(fnt_SHP)
        FntFuncI(fnt_SHC) FntFuncI(fnt_SHC) FntFuncI(fnt_SHE) FntFuncI(fnt_SHE)
        FntFuncI(fnt_SHPIX) FntFuncI(fnt_IP) FntFuncI(fnt_MSIRP) FntFuncI(fnt_MSIRP)
        FntFuncI(fnt_ALIGNRP) FntFuncI(fnt_SetRoundState) FntFuncI(fnt_MIAP) FntFuncI(fnt_MIAP)
        /* RTDG <- fnt_SetRoundState */
        FntFuncI(fnt_NPUSHB) FntFuncI(fnt_NPUSHW) FntFuncI(fnt_WS) FntFuncI(fnt_RS)
        FntFuncI(fnt_WCVT) FntFuncI(fnt_RCVT) FntFuncI(fnt_RC) FntFuncI(fnt_RC)
        FntFuncI(fnt_WC) FntFuncI(fnt_MD) FntFuncI(fnt_MD) FntFuncI(fnt_MPPEM)
        FntFuncI(fnt_MPS) FntFuncI(fnt_FLIPON) FntFuncI(fnt_FLIPOFF) FntFuncI(fnt_DEBUG)
        FntFuncI(fnt_BinaryOperand) FntFuncI(fnt_BinaryOperand)      /* LT LTEQ  */
        FntFuncI(fnt_BinaryOperand) FntFuncI(fnt_BinaryOperand)    /* GT GTEQ  */
        FntFuncI(fnt_BinaryOperand) FntFuncI(fnt_BinaryOperand)    /* EQ NEQ   */
        FntFuncI(fnt_UnaryOperand) FntFuncI(fnt_UnaryOperand)      /* ODD EVEN */
        FntFuncI(fnt_IF) FntFuncI(fnt_EIF)
        FntFuncI(fnt_BinaryOperand) FntFuncI(fnt_BinaryOperand)    /* AND OR   */
        FntFuncI(fnt_UnaryOperand) FntFuncI(fnt_DELTAP1)           /* NOT      */
        FntFuncI(fnt_SDB) FntFuncI(fnt_SDS)
        FntFuncI(fnt_BinaryOperand) FntFuncI(fnt_BinaryOperand)      /* ADD SUB  */
        FntFuncI(fnt_BinaryOperand) FntFuncI(fnt_BinaryOperand)    /* DIV MUL  */
        FntFuncI(fnt_UnaryOperand) FntFuncI(fnt_UnaryOperand)      /* ABS NEG  */
        FntFuncI(fnt_UnaryOperand) FntFuncI(fnt_UnaryOperand)      /* FLOOR CEILING */
        FntFuncI(fnt_ROUND) FntFuncI(fnt_ROUND) FntFuncI(fnt_ROUND) FntFuncI(fnt_ROUND)
        FntFuncI(fnt_NROUND) FntFuncI(fnt_NROUND) FntFuncI(fnt_NROUND) FntFuncI(fnt_NROUND)
        FntFuncI(fnt_WCVTFOD) FntFuncI(fnt_DELTAP2) FntFuncI(fnt_DELTAP3) FntFuncI(fnt_DELTAC1)
        FntFuncI(fnt_DELTAC2) FntFuncI(fnt_DELTAC3) FntFuncI(fnt_SROUND) FntFuncI(fnt_S45ROUND)
        FntFuncI(fnt_JROT) FntFuncI(fnt_JROF) FntFuncI(fnt_SetRoundState) /* ROFF */
        FntFuncI(fnt_IllegalInstruction)
        FntFuncI(fnt_SetRoundState) FntFuncI(fnt_SetRoundState)    /* RUTG RDTG */
        FntFuncI(fnt_SANGW) FntFuncI(fnt_AA)
        FntFuncI(fnt_FLIPPT) FntFuncI(fnt_FLIPRGON) FntFuncI(fnt_FLIPRGOFF) FntFuncI(fnt_IDefPatch)
        FntFuncI(fnt_IDefPatch) FntFuncI(fnt_SCANCTRL) FntFuncI(fnt_SDPVTL) FntFuncI(fnt_SDPVTL)
        FntFuncI(fnt_GETINFO) FntFuncI(fnt_IDEF) FntFuncI(fnt_ROTATE)
        FntFuncI(fnt_BinaryOperand) FntFuncI(fnt_BinaryOperand)       /* MAX MIN  */
        FntFuncI(fnt_SCANTYPE) FntFuncI(fnt_INSTCTRL) FntFuncI(fnt_IDefPatch)
        FntFuncI(fnt_IDefPatch) FntFuncI(fnt_IDefPatch) FntFuncI(fnt_IDefPatch) FntFuncI(fnt_IDefPatch)
        FntFuncI(fnt_IDefPatch) FntFuncI(fnt_IDefPatch) FntFuncI(fnt_IDefPatch) FntFuncI(fnt_IDefPatch)
        FntFuncI(fnt_IDefPatch) FntFuncI(fnt_IDefPatch) FntFuncI(fnt_IDefPatch) FntFuncI(fnt_IDefPatch)
        FntFuncI(fnt_IDefPatch) FntFuncI(fnt_IDefPatch) FntFuncI(fnt_IDefPatch) FntFuncI(fnt_IDefPatch)
        FntFuncI(fnt_IDefPatch) FntFuncI(fnt_IDefPatch)
        FntFuncI(fnt_MAZDELTA1) FntFuncI(fnt_MAZDELTA2)  FntFuncI(fnt_MAZDELTA3)
        FntFuncI(fnt_MAZMODE) FntFuncI(fnt_MAZSTROKE)
        FntFuncI(fnt_DELTAK1)
        FntFuncI(fnt_DELTAK2) FntFuncI(fnt_DELTAK3) FntFuncI(fnt_DELTAL1) FntFuncI(fnt_DELTAL2)
        FntFuncI(fnt_DELTAL3) FntFuncI(fnt_DELTAS1) FntFuncI(fnt_DELTAS2) FntFuncI(fnt_DELTAS3)
        FntFuncI(fnt_PUSHB) FntFuncI(fnt_PUSHB) FntFuncI(fnt_PUSHB) FntFuncI(fnt_PUSHB)
        FntFuncI(fnt_PUSHB) FntFuncI(fnt_PUSHB) FntFuncI(fnt_PUSHB) FntFuncI(fnt_PUSHB)
        FntFuncI(fnt_PUSHW) FntFuncI(fnt_PUSHW) FntFuncI(fnt_PUSHW) FntFuncI(fnt_PUSHW)
        FntFuncI(fnt_PUSHW) FntFuncI(fnt_PUSHW) FntFuncI(fnt_PUSHW) FntFuncI(fnt_PUSHW)
        FntFuncI(fnt_MDRP) FntFuncI(fnt_MDRP) FntFuncI(fnt_MDRP) FntFuncI(fnt_MDRP)
        FntFuncI(fnt_MDRP) FntFuncI(fnt_MDRP) FntFuncI(fnt_MDRP) FntFuncI(fnt_MDRP)
        FntFuncI(fnt_MDRP) FntFuncI(fnt_MDRP) FntFuncI(fnt_MDRP) FntFuncI(fnt_MDRP)
        FntFuncI(fnt_MDRP) FntFuncI(fnt_MDRP) FntFuncI(fnt_MDRP) FntFuncI(fnt_MDRP)
        FntFuncI(fnt_MDRP) FntFuncI(fnt_MDRP) FntFuncI(fnt_MDRP) FntFuncI(fnt_MDRP)
        FntFuncI(fnt_MDRP) FntFuncI(fnt_MDRP) FntFuncI(fnt_MDRP) FntFuncI(fnt_MDRP)
        FntFuncI(fnt_MDRP) FntFuncI(fnt_MDRP) FntFuncI(fnt_MDRP) FntFuncI(fnt_MDRP)
        FntFuncI(fnt_MDRP) FntFuncI(fnt_MDRP) FntFuncI(fnt_MDRP) FntFuncI(fnt_MDRP)
        FntFuncI(fnt_MIRP) FntFuncI(fnt_MIRP) FntFuncI(fnt_MIRP) FntFuncI(fnt_MIRP)
        FntFuncI(fnt_MIRP) FntFuncI(fnt_MIRP) FntFuncI(fnt_MIRP) FntFuncI(fnt_MIRP)
        FntFuncI(fnt_MIRP) FntFuncI(fnt_MIRP) FntFuncI(fnt_MIRP) FntFuncI(fnt_MIRP)
        FntFuncI(fnt_MIRP) FntFuncI(fnt_MIRP) FntFuncI(fnt_MIRP) FntFuncI(fnt_MIRP)
        FntFuncI(fnt_MIRP) FntFuncI(fnt_MIRP) FntFuncI(fnt_MIRP) FntFuncI(fnt_MIRP)
        FntFuncI(fnt_MIRP) FntFuncI(fnt_MIRP) FntFuncI(fnt_MIRP) FntFuncI(fnt_MIRP)
        FntFuncI(fnt_MIRP) FntFuncI(fnt_MIRP) FntFuncI(fnt_MIRP) FntFuncI(fnt_MIRP)
        FntFuncI(fnt_MIRP) FntFuncI(fnt_MIRP) FntFuncI(fnt_MIRP) FntFuncI(fnt_MIRP)
    }
#ifndef GLOBAL_STATIC_FUNCTION_PTRS_OK
}  /*lint !e438 Suppress "Last value assigned...not used"*/
#else
    ;
#endif /* GLOBAL_STATIC_FUNCTION_PTRS_OK */

/* The hinting functions in the "interpFunc[]" table of the user-defined
 * opcodes 0xa2-0xaf correspond to ITYPE hinting functions by default.
 * This is the correct mode of operation when processing MTI fonts. However, for fonts
 * created outside of MTI, these opcodes should be associated with the generic function
 * fnt_IDefPatch().
 *
 * The way we detect a non-MTI font is by checking if any of the above 
 * user-defined opcode is defined by IDEFs in fpgm.
 */
FS_VOID set_UD_functions(FS_BYTE UD_function_type)
{
    FS_USHORT i = (FS_USHORT)START_OF_UD_OPCODES;

    /* Set functions corresponding to user-defined opcodes (0xa2-0xaf) ... */
    if (UD_function_type == ITYPE_UD_FUNCTIONS)
    {
        /* ... to ITYPE's STIK- and EDGE- functions */
        interpFunc[i++] = FntFuncII(fnt_MAZDELTA1);
        interpFunc[i++] = FntFuncII(fnt_MAZDELTA2);
        interpFunc[i++] = FntFuncII(fnt_MAZDELTA3);
        interpFunc[i++] = FntFuncII(fnt_MAZMODE);
        interpFunc[i++] = FntFuncII(fnt_MAZSTROKE);
        interpFunc[i++] = FntFuncII(fnt_DELTAK1);
        interpFunc[i++] = FntFuncII(fnt_DELTAK2);
        interpFunc[i++] = FntFuncII(fnt_DELTAK3);
        interpFunc[i++] = FntFuncII(fnt_DELTAL1);
        interpFunc[i++] = FntFuncII(fnt_DELTAL2);
        interpFunc[i++] = FntFuncII(fnt_DELTAL3);
        interpFunc[i++] = FntFuncII(fnt_DELTAS1);
        interpFunc[i++] = FntFuncII(fnt_DELTAS2);
        interpFunc[i++] = FntFuncII(fnt_DELTAS3);
    }
    else
    {
        /* ... to generic fnt_IDefPatch() */
        for (i=(FS_USHORT)START_OF_UD_OPCODES; i<= END_OF_UD_OPCODES; i++)
            interpFunc[i] = FntFuncII(fnt_IDefPatch);
    }
}

#undef FntFuncI
#undef FntFuncII

#ifndef KILL_SETJMP_LONGJMP
/*
 * We exit through here, when we detect serious errors.
 */
static FS_VOID fnt_Panic( fnt_LocalGraphicStateType* gs, int val )
{
    longjmp( gs->env, val ); /* Do a gracefull recovery  */
}
#endif /* not KILL_SETJMP_LONGJMP */

/*
 * Illegal instruction panic
 */
static FS_VOID fnt_IllegalInstruction(fnt_LocalGraphicStateType *gs)
{
#ifdef KILL_SETJMP_LONGJMP
    gs->error = UNDEFINED_INSTRUCTION_ERR;
#else
    fnt_Panic( gs, UNDEFINED_INSTRUCTION_ERR );
#endif
}

/* log_2(a) ... sort of */
static int bitcount(FS_ULONG a)
{
    int count = 0;
    while (a)
    {
        a >>= 1;
        count++;
    }
    return count;
}

#ifndef FS_EDGE_HINTS
/* generate error for edge hints when FS_EDGE_HINTS undefined */
static FS_VOID edgehints_err(fnt_LocalGraphicStateType *gs)
{
#ifdef KILL_SETJMP_LONGJMP
    gs->error = ERR_FS_EDGE_HINTS_UNDEF;
#else
    fnt_Panic( gs, ERR_FS_EDGE_HINTS_UNDEF);
#endif
}
#endif

/* generate a unit vector from <x,y> */
static FS_VOID fnt_Normalize(F26DOT6 x, F26DOT6 y, SHORT_UNIT_VECTOR *v)
{
    /*
     *    Since x and y are 26.6, and currently that means they are really 16.6,
     *    when treated as FRACT, they are 0.[8]22, so shift up to 0.30 for accuracy
     */

    CHECK_RANGE(x, -32768L << 6, 32767L << 6);
    CHECK_RANGE(y, -32768L << 6, 32767L << 6);

    {
        FRACT xx = x;
        FRACT yy = y;
        int shift;
        if (xx < 0)    xx = -xx;
        if (yy < 0) yy = -yy;
        if (xx < yy) xx = yy;
        /*
         *    0.5 <= max(x,y) < 1
         */
        shift = 8 * sizeof(FRACT) - 2 - bitcount(xx);
        x <<= shift;
        y <<= shift;
    }
    {
        FRACT length;
        if ((length = FracSqrt( FracMul(x, x) + FracMul(y, y) )) != 0)
        {
            v->x = FS_ROUND( FracDiv( x, length ) );
            v->y = FS_ROUND( FracDiv( y, length ) );
        }
        else  /* if x & y are both 0 (which shouldn't happen!!) - 2/25/97 */
        {
            v->x = SHORTFRACT_ONE;
            v->y = 0;
        }
    }
}

/******************** BEGIN Rounding Routines ***************************/

/*
 * Internal rounding routine
 */
F26DOT6 fnt_RoundToDoubleGrid(F26DOT6 xin, F26DOT6 engine, fnt_LocalGraphicStateType* gs)
{
    F26DOT6 x = xin;

    (void)gs; /* not used in this rounding function */

    if ( x >= 0 )
    {
        x += engine;
        x += fnt_pixelSize / 4;
        x &= ~(fnt_pixelSize / 2 - 1);
    }
    else
    {
        x = -x;
        x += engine;
        x += fnt_pixelSize / 4;
        x &= ~(fnt_pixelSize / 2 - 1);
        x = -x;
    }
    if ( ((FS_LONG)(xin ^ x)) < 0 && xin )
    {
        x = 0; /* The sign flipped, make zero */
    }
    return x;
}

/*
 * Internal rounding routine
 */
F26DOT6 fnt_RoundDownToGrid(F26DOT6 xin, F26DOT6 engine, fnt_LocalGraphicStateType* gs)
{
    F26DOT6 x = xin;

    (void)gs; /* not used in this rounding function */

    if ( x >= 0 )
    {
        x += engine;
        x &= ~(fnt_pixelSize - 1);
    }
    else
    {
        x = -x;
        x += engine;
        x &= ~(fnt_pixelSize - 1);
        x = -x;
    }
    if ( ((FS_LONG)(xin ^ x)) < 0 && xin )
    {
        x = 0; /* The sign flipped, make zero */
    }
    return x;
}

/*
 * Internal rounding routine
 */
F26DOT6 fnt_RoundUpToGrid(F26DOT6 xin, F26DOT6 engine, fnt_LocalGraphicStateType* gs)
{
    F26DOT6 x = xin;

    (void)gs; /* not used in this rounding function */

    if ( x >= 0 )
    {
        x += engine;
        x += fnt_pixelSize - 1;
        x &= ~(fnt_pixelSize - 1);
    }
    else
    {
        x = -x;
        x += engine;
        x += fnt_pixelSize - 1;
        x &= ~(fnt_pixelSize - 1);
        x = -x;
    }
    if ( ((FS_LONG)(xin ^ x)) < 0 && xin )
    {
        x = 0; /* The sign flipped, make zero */
    }
    return x;
}

/*
 * Internal rounding routine
 */
F26DOT6 fnt_RoundToGrid(F26DOT6 xin, F26DOT6 engine, fnt_LocalGraphicStateType* gs)
{
    F26DOT6 x = xin;

    (void)gs; /* not used in this rounding function */

    if ( x >= 0 )
    {
        x += engine;
        x += fnt_pixelSize / 2;
        x &= ~(fnt_pixelSize - 1);
    }
    else
    {
        x = -x;
        x += engine;
        x += fnt_pixelSize / 2;
        x &= ~(fnt_pixelSize - 1);
        x = -x;
    }
    if ( ((FS_LONG)(xin ^ x)) < 0 && xin )
    {
        x = 0; /* The sign flipped, make zero */
    }
    return x;
}


/*
 * Internal rounding routine
 */
F26DOT6 fnt_RoundToHalfGrid(F26DOT6 xin, F26DOT6 engine, fnt_LocalGraphicStateType* gs)
{
    F26DOT6 x = xin;

    (void)gs; /* not used in this rounding function */

    if ( x >= 0 )
    {
        x += engine;
        x &= ~(fnt_pixelSize - 1);
        x += fnt_pixelSize / 2;
    }
    else
    {
        x = -x;
        x += engine;
        x &= ~(fnt_pixelSize - 1);
        x += fnt_pixelSize / 2;
        x = -x;
    }
    if ( ((FS_LONG)(xin ^ x)) < 0 && xin )
    {
        x = xin > 0 ? fnt_pixelSize / 2 : -fnt_pixelSize / 2; /* The sign flipped, make equal to smallest valid value */
    }
    return x;
}

/*
 * Internal rounding routine
 */
F26DOT6 fnt_RoundOff(F26DOT6 xin, F26DOT6 engine, fnt_LocalGraphicStateType* gs)
{
    F26DOT6 x = xin;

    (void)gs; /* not used in this rounding function */

    if ( x >= 0 )
    {
        x += engine;
    }
    else
    {
        x -= engine;
    }
    if ( ((FS_LONG)(xin ^ x)) < 0 && xin)
    {
        x = 0; /* The sign flipped, make zero */
    }
    return x;
}


/*
 * Internal rounding routine
 */
F26DOT6 fnt_SuperRound(F26DOT6 xin, F26DOT6 engine, fnt_LocalGraphicStateType *gs)
{
    F26DOT6 x = xin;
    fnt_ParameterBlock *pb = &gs->globalGS->localParBlock;

    if ( x >= 0 )
    {
        x += engine;
        x += pb->threshold - pb->phase;
        x &= pb->periodMask;
        x += pb->phase;
    }
    else
    {
        x = -x;
        x += engine;
        x += pb->threshold - pb->phase;
        x &= pb->periodMask;
        x += pb->phase;
        x = -x;
    }
    if ( ((FS_LONG)(xin ^ x)) < 0 && xin )
    {
        x = xin > 0 ? pb->phase : -pb->phase; /* The sign flipped, make equal to smallest phase */
    }
    return x;
}

/*
 * Internal rounding routine
 */
F26DOT6 fnt_Super45Round(F26DOT6 xin, F26DOT6 engine, fnt_LocalGraphicStateType *gs)
{
    F26DOT6 x = xin;
    fnt_ParameterBlock *pb = &gs->globalGS->localParBlock;

    if ( x >= 0 )
    {
        x += engine;
        x += pb->threshold - pb->phase;
        x = FracDiv( x, pb->period45 );
        x  &= ~(fnt_pixelSize - 1);
        x = FracMul( x, pb->period45 );
        x += pb->phase;
    }
    else
    {
        x = -x;
        x += engine;
        x += pb->threshold - pb->phase;
        x = FracDiv( x, pb->period45 );
        x  &= ~(fnt_pixelSize - 1);
        x = FracMul( x, pb->period45 );
        x += pb->phase;
        x = -x;
    }
    if ( ((FS_LONG)(xin ^ x)) < 0 && xin )
    {
        x = xin > 0 ? pb->phase : -pb->phase; /* The sign flipped, make equal to smallest phase */
    }
    return x;
}


/*
 * Moves the point in element by delta (measured against the projection vector)
 * along the freedom vector.
 */
static FS_VOID fnt_MovePoint(fnt_LocalGraphicStateType *gs,
                             fnt_ElementType *element,
                             FS_LONG point,
                             F26DOT6 delta)
{
    SHORTFRACT pfProj = gs->pfProj;
    SHORTFRACT fx = gs->freedom.x;
    SHORTFRACT fy = gs->freedom.y;

    CHECK_POINT( gs, element, point );

    if ( pfProj != SHORTFRACT_ONE )
    {
        if ( fx )
        {
            element->x[point] += VECTORMULDIV( delta, fx, pfProj );
            element->f[point] |= XMOVED;
        }
        if ( fy )
        {
            element->y[point] += VECTORMULDIV( delta, fy, pfProj );
            element->f[point] |= YMOVED;
        }
    }
    else
    {
        if ( fx )
        {
            element->x[point] += VECTORMUL( delta, fx );
            element->f[point] |= XMOVED;
        }
        if ( fy )
        {
            element->y[point] += VECTORMUL( delta, fy );
            element->f[point] |= YMOVED;
        }
    }
}

/*
 * For use when the projection and freedom vectors coincide along the x-axis.
 */
static FS_VOID fnt_XMovePoint( fnt_LocalGraphicStateType* gs, fnt_ElementType* element, FS_LONG point, F26DOT6 delta )
{
    (void)gs; /* may not be used in this move function */

    CHECK_POINT( gs, element, point );
    element->x[point] += delta;
    element->f[point] |= XMOVED;
}

/*
 * For use when the projection and freedom vectors coincide along the y-axis.
 */
static FS_VOID fnt_YMovePoint( fnt_LocalGraphicStateType* gs, fnt_ElementType *element, FS_LONG point, F26DOT6 delta )
{
    (void)gs; /* may not be used in this move function */

    CHECK_POINT( gs, element, point );
    element->y[point] += delta;
    element->f[point] |= YMOVED;
}


/*
 * projects x and y into the projection vector.
 */
static F26DOT6 fnt_Project(fnt_LocalGraphicStateType* gs, F26DOT6 x, F26DOT6 y)
{
    return( VECTORMUL( x, gs->proj.x ) + VECTORMUL( y, gs->proj.y ) );
}

/*
 * projects x and y into the old projection vector.
 */
static F26DOT6 fnt_OldProject(fnt_LocalGraphicStateType* gs, F26DOT6 x, F26DOT6 y)
{
    return( VECTORMUL( x, gs->oldProj.x ) + VECTORMUL( y, gs->oldProj.y ) );
}


/*
 * Projects when the projection vector is along the x-axis
 */
static F26DOT6 fnt_XProject(fnt_LocalGraphicStateType* gs, F26DOT6 x, F26DOT6 y)
{
    (void)gs; /* not used in this projection function */
    (void)y;  /* not used in this projection function */
    return( x );
}

/*
 * Projects when the projection vector is along the y-axis
 */
static F26DOT6 fnt_YProject(fnt_LocalGraphicStateType* gs, F26DOT6 x, F26DOT6 y)
{
    (void)gs; /* not used in this projection function */
    (void)x;  /* not used in this projection function */

    return( y );
}

/*************************************************************************/

/*** Compensation for Transformations ***/


static FS_FIXED fnt_GetCVTScale(fnt_LocalGraphicStateType* gs)
{
    SHORTFRACT pvx, pvy;
    FS_FIXED x2, sum;
    FS_FIXED y2;
    fnt_GlobalGraphicStateType *globalGS = gs->globalGS;

    pvx = gs->proj.x;
    pvy = gs->proj.y;
    if (pvy)
    {
        if (pvx)
        {
            pvx = VECTORDOT(pvx, pvx);
            pvy = VECTORDOT(pvy, pvy);
            x2 = FixMul(globalGS->cvtStretchX, globalGS->cvtStretchX);
            y2 = FixMul(globalGS->cvtStretchY, globalGS->cvtStretchY);
            sum = FixMul(FRAC2FIX(pvx), x2) + FixMul(FRAC2FIX(pvy), y2);
            if (sum >= FIXED_ONE)
                return FIXED_ONE;    /* Won't happen */

            /* convert sum into a 2.30 fraction  */
            /* take the sqrt ... convert it back to 16.16 */
            return (FracSqrt(sum << 14) + (1 << 13)) >> 14;
        }
        else
            return globalGS->cvtStretchY;
    }
    else
        return globalGS->cvtStretchX;

}


/*    Functions for function pointer in local graphic state
*/
static F26DOT6 fnt_GetCVTEntryFast(fnt_LocalGraphicStateType* gs, FS_LONG n)
{
    CHECK_CVT( gs, (FS_LONG)n );
    if(n >= gs->globalGS->cvtCount)
        return 0;
    return gs->globalGS->controlValueTable[ n ];
}

static F26DOT6 fnt_GetCVTEntrySlow(fnt_LocalGraphicStateType *gs, FS_LONG n)
{
    FS_FIXED scale;

    CHECK_CVT( gs, (FS_LONG)n );
    if(n >= gs->globalGS->cvtCount)
        return 0;
    scale = fnt_GetCVTScale( gs );
    return ( FixMul( gs->globalGS->controlValueTable[ n ], scale ) );
}

static F26DOT6 fnt_GetSingleWidthFast(fnt_LocalGraphicStateType *gs)
{
    return gs->globalGS->localParBlock.scaledSW;
}

static F26DOT6 fnt_GetSingleWidthSlow(fnt_LocalGraphicStateType *gs)
{
    FS_FIXED scale;

    scale = fnt_GetCVTScale( gs );
    return ( FixMul( gs->globalGS->localParBlock.scaledSW, scale ) );
}

static FS_VOID fnt_ChangeCvt(fnt_LocalGraphicStateType* gs, fnt_ElementType* elem,
                             FS_LONG number, F26DOT6 delta)
{
    FS_FIXED scale;

    (void)elem; /* not used in this move function */
    CHECK_CVT( gs, (FS_LONG)number );
    if(number >= gs->globalGS->cvtCount)
        return;
    scale = fnt_GetCVTScale( gs );
    gs->globalGS->controlValueTable[ number ] += FixDiv(delta, scale);
}

/*
 * This is the fast non-tracing interpreter.
 */
static FS_VOID fnt_InnerExecute(fnt_LocalGraphicStateType *gs, FS_BYTE *ptr, FS_BYTE *eptr)

{
    FS_BYTE *oldInsPtr;

    oldInsPtr = gs->insPtr;
    gs->insPtr = ptr;

#ifdef FS_TRACE
    indent_is++;
#endif
    CHECK_STATE( gs );

    while ( gs->insPtr < eptr  && !gs->error)
    {
        gs->opCode = *gs->insPtr++;
#ifdef FS_TRACE
        if (in_char)
            trace_fn1(gs);
#endif
        interpFunc[ gs->opCode ]( gs );
        CHECK_STATE( gs );
    }
#ifdef FS_TRACE
    if (in_char)
        trace_fn2(gs);
    indent_is--;
#endif

    gs->insPtr = oldInsPtr;
}


/*
 * Executes the font instructions.
 * This is the external interface to the interpreter.
 *
 * Parameter Description
 *
 * elements points to the character elements. Element 0 is always
 * reserved and not used by the actual character.
 *
 * ptr points at the first instruction.
 * eptr points to right after the last instruction
 *
 * globalGS points at the global graphics state
 *
 * Note: The stuff globalGS is pointing at must remain intact
 *       between calls to this function.
 */

FS_LONG fnt_Execute(fnt_ElementType *elements, FS_BYTE *ptr, FS_BYTE *eptr,
                    fnt_GlobalGraphicStateType *globalGS)

{
    fnt_LocalGraphicStateType GS;
    fnt_LocalGraphicStateType *gs; /* the local graphics state pointer */

#ifndef KILL_SETJMP_LONGJMP
    int result;
#endif /* KILL_SETJMP_LONGJMP */


    gs = &GS;
    gs->globalGS = globalGS;

    gs->elements = elements;
    gs->Pt0 = gs->Pt1 = gs->Pt2 = 0;
    gs->CE0 = gs->CE1 = gs->CE2 = &elements[1];
    gs->freedom.x = gs->proj.x = gs->oldProj.x = ONEVECTOR;
    gs->freedom.y = gs->proj.y = gs->oldProj.y = 0;
    gs->pfProj = ONEVECTOR;
    gs->MovePoint = (FntMoveFunc)fnt_XMovePoint;
    gs->Project   = (FntProjFunc)fnt_XProject;
    gs->OldProject = (FntProjFunc)fnt_XProject;
    gs->loop = 0;        /* 1 less than count for faster loops. mrr */
    gs->insPtr = 0;

    if ( globalGS->pgmIndex == FONTPROGRAM )
    {
#ifdef FS_DEBUG
        gs->GetCVTEntry = fnt_Nil_gsGetCVTEntry;
        gs->GetSingleWidth = fnt_Nil_gsGetSingleWidth;
#endif
    }
    else
    {
        if ( globalGS->pixelsPerEm <= 1 )
            return NO_ERR;
        if ( globalGS->identityTransformation )
        {
            gs->GetCVTEntry = fnt_GetCVTEntryFast;
            gs->GetSingleWidth = fnt_GetSingleWidthFast;
        }
        else
        {
            gs->GetCVTEntry = fnt_GetCVTEntrySlow;
            gs->GetSingleWidth = fnt_GetSingleWidthSlow;
            if ( FixMul( globalGS->fpem, globalGS->xStretch ) <= FIXED_ONE ||
                    FixMul( globalGS->fpem, globalGS->yStretch ) <= FIXED_ONE )
                return NO_ERR;
        }

        if ( globalGS->init )
        {
            /* formerly CHECK_TRASHED_MEMORY case */
        }
        else if ( globalGS->localParBlock.sW )
        {
            /*lint -e571  Warning 571: Warning -- Suspicious cast */
            /* We need to scale the single width for this size  */
            globalGS->localParBlock.scaledSW = ScaleFuncCall(globalGS->scaleFuncCVT, &globalGS->scaleCVT, (FS_ULONG)globalGS->localParBlock.sW);
            /*lint +e571  Warning 571: Warning -- Suspicious cast */
        }
    }

    gs->stackPointer = globalGS->stackBase;

#ifndef KILL_SETJMP_LONGJMP
    result = setjmp(gs->env);
    if (result)
        return( result );
#endif
    gs->error = 0;

    fnt_InnerExecute( gs, ptr, eptr );

#ifndef KILL_SETJMP_LONGJMP
    return NO_ERR;
#else
    return gs->error ? gs->error : NO_ERR;
#endif
}


/*************************************************************************/

/*** 2 internal gs->pfProj computation support routines ***/

/*
 * Only does the check of gs->pfProj
 */
static FS_VOID fnt_Check_PF_Proj(fnt_LocalGraphicStateType *gs)
{
    SHORTFRACT pfProj = gs->pfProj;

    if ( pfProj > -ONESIXTEENTHVECTOR && pfProj < ONESIXTEENTHVECTOR)
    {
        gs->pfProj = pfProj < 0 ? (SHORTFRACT) - ONEVECTOR : (SHORTFRACT)ONEVECTOR; /* Prevent divide by small number */
    }
}


/*
 * Computes gs->pfProj and then does the check
 */
static FS_VOID fnt_ComputeAndCheck_PF_Proj(fnt_LocalGraphicStateType *gs)
{
    SHORTFRACT pfProj;

    pfProj = VECTORDOT( gs->proj.x, gs->freedom.x ) + VECTORDOT( gs->proj.y, gs->freedom.y );
    if ( pfProj > -ONESIXTEENTHVECTOR && pfProj < ONESIXTEENTHVECTOR)
    {
        pfProj = pfProj < 0 ? (SHORTFRACT) - ONEVECTOR : (SHORTFRACT)ONEVECTOR; /* Prevent divide by small number */
    }
    gs->pfProj = pfProj;
}



/******************************************/
/******** The Actual Instructions *********/
/******************************************/

/*
 * Set Vectors To Coordinate Axis - Y
 */
static FS_VOID fnt_SVTCA_0( fnt_LocalGraphicStateType* gs )
{
    gs->freedom.x = gs->proj.x = 0;
    gs->freedom.y = gs->proj.y = ONEVECTOR;
    gs->MovePoint = (FntMoveFunc)fnt_YMovePoint;
    gs->Project = (FntProjFunc)fnt_YProject;
    gs->OldProject = (FntProjFunc)fnt_YProject;
    gs->pfProj = ONEVECTOR;
}

/*
 * Set Vectors To Coordinate Axis - X
 */
static FS_VOID fnt_SVTCA_1( fnt_LocalGraphicStateType* gs )
{
    gs->freedom.x = gs->proj.x = ONEVECTOR;
    gs->freedom.y = gs->proj.y = 0;
    gs->MovePoint = (FntMoveFunc)fnt_XMovePoint;
    gs->Project = (FntProjFunc)fnt_XProject;
    gs->OldProject = (FntProjFunc)fnt_XProject;
    gs->pfProj = ONEVECTOR;
}

/*
 * Set Projection Vector To Coordinate Axis
 */
static FS_VOID fnt_SPVTCA( fnt_LocalGraphicStateType* gs )
{
    if ( BIT0( gs->opCode )  )
    {
        gs->proj.x = ONEVECTOR;
        gs->proj.y = 0;
        gs->Project = (FntProjFunc)fnt_XProject;
        gs->pfProj = gs->freedom.x;
    }
    else
    {
        gs->proj.x = 0;
        gs->proj.y = ONEVECTOR;
        gs->Project = (FntProjFunc)fnt_YProject;
        gs->pfProj = gs->freedom.y;
    }
    fnt_Check_PF_Proj( gs );
    gs->MovePoint = (FntMoveFunc)fnt_MovePoint;
    gs->OldProject = gs->Project;
}

/*
 * Set Freedom Vector to Coordinate Axis
 */
static FS_VOID fnt_SFVTCA( fnt_LocalGraphicStateType* gs )
{
    if ( BIT0( gs->opCode )  )
    {
        gs->freedom.x = ONEVECTOR;
        gs->freedom.y = 0;
        gs->pfProj = gs->proj.x;
    }
    else
    {
        gs->freedom.x = 0;
        gs->freedom.y = ONEVECTOR;
        gs->pfProj = gs->proj.y;
    }
    fnt_Check_PF_Proj( gs );
    gs->MovePoint = (FntMoveFunc)fnt_MovePoint;
}

/*
 * Set Projection Vector To Line
 */
static FS_VOID fnt_SPVTL(fnt_LocalGraphicStateType *gs)
{
    FS_LONG arg1, arg2;

    arg2 = (FS_LONG)CHECK_POP(gs, gs->stackPointer );
    arg1 = (FS_LONG)CHECK_POP(gs, gs->stackPointer );



    CHECK_POINT( gs, gs->CE2, arg2 );
    CHECK_POINT( gs, gs->CE1, arg1 );

    fnt_Normalize( gs->CE1->x[arg1] - gs->CE2->x[arg2], gs->CE1->y[arg1] - gs->CE2->y[arg2], &gs->proj );
    if ( BIT0( gs->opCode ) )
    {
        /* rotate 90 degrees */
        SHORTFRACT tmp    = gs->proj.y;
        gs->proj.y        = gs->proj.x;
        gs->proj.x        = -tmp;
    }
    fnt_ComputeAndCheck_PF_Proj( gs );
    gs->MovePoint = (FntMoveFunc)fnt_MovePoint;
    gs->Project = (FntProjFunc)fnt_Project;
    gs->OldProject = gs->Project;
}


/*
 * Set Dual Projection Vector To Line
 */
static FS_VOID fnt_SDPVTL(fnt_LocalGraphicStateType *gs)
{
    FS_LONG arg1, arg2;

    arg2 = (FS_LONG)CHECK_POP(gs, gs->stackPointer );
    arg1 = (FS_LONG)CHECK_POP(gs, gs->stackPointer );



    CHECK_POINT( gs, gs->CE2, arg2 );
    CHECK_POINT( gs, gs->CE1, arg1 );

    /* Do the current domain */
    fnt_Normalize( gs->CE1->x[arg1] - gs->CE2->x[arg2], gs->CE1->y[arg1] - gs->CE2->y[arg2], &gs->proj );

    /* Do the old domain */
    fnt_Normalize( gs->CE1->ox[arg1] - gs->CE2->ox[arg2], gs->CE1->oy[arg1] - gs->CE2->oy[arg2], &gs->oldProj );

    if ( BIT0( gs->opCode ) )
    {
        /* rotate 90 degrees */
        SHORTFRACT tmp    = gs->proj.y;
        gs->proj.y        = gs->proj.x;
        gs->proj.x        = -tmp;

        tmp                = gs->oldProj.y;
        gs->oldProj.y    = gs->oldProj.x;
        gs->oldProj.x    = -tmp;
    }
    fnt_ComputeAndCheck_PF_Proj( gs );

    gs->MovePoint = (FntMoveFunc)fnt_MovePoint;
    gs->Project = (FntProjFunc)fnt_Project;
    gs->OldProject = (FntProjFunc)fnt_OldProject;
}

/*
 * Set Freedom Vector To Line
 */
static FS_VOID fnt_SFVTL(fnt_LocalGraphicStateType *gs)
{
    FS_LONG arg1, arg2;

    arg2 = (FS_LONG)CHECK_POP(gs, gs->stackPointer );
    arg1 = (FS_LONG)CHECK_POP(gs, gs->stackPointer );



    CHECK_POINT( gs, gs->CE2, arg2 );
    CHECK_POINT( gs, gs->CE1, arg1 );

    fnt_Normalize( gs->CE1->x[arg1] - gs->CE2->x[arg2], gs->CE1->y[arg1] - gs->CE2->y[arg2], &gs->freedom );
    if ( BIT0( gs->opCode ) )
    {
        /* rotate 90 degrees */
        SHORTFRACT tmp    = gs->freedom.y;
        gs->freedom.y     = gs->freedom.x;
        gs->freedom.x     = -tmp;
    }
    fnt_ComputeAndCheck_PF_Proj( gs );
    gs->MovePoint = (FntMoveFunc)fnt_MovePoint;
}


/*
 * Write Projection Vector
 */
static FS_VOID fnt_WPV(fnt_LocalGraphicStateType *gs)
{
    gs->proj.y = (SHORTFRACT)CHECK_POP(gs, gs->stackPointer);
    gs->proj.x = (SHORTFRACT)CHECK_POP(gs, gs->stackPointer);

    fnt_ComputeAndCheck_PF_Proj( gs );

    gs->MovePoint = (FntMoveFunc)fnt_MovePoint;
    gs->Project = (FntProjFunc)fnt_Project;
    gs->OldProject = gs->Project;
}

/*
 * Write Freedom vector
 */
static FS_VOID fnt_WFV(fnt_LocalGraphicStateType *gs)
{
    gs->freedom.y = (SHORTFRACT)CHECK_POP(gs, gs->stackPointer);
    gs->freedom.x = (SHORTFRACT)CHECK_POP(gs, gs->stackPointer);

    fnt_ComputeAndCheck_PF_Proj( gs );

    gs->MovePoint = (FntMoveFunc)fnt_MovePoint;
}

/*
 * Read Projection Vector
 */
static FS_VOID fnt_RPV(fnt_LocalGraphicStateType *gs)
{
    CHECK_PUSH( gs, gs->stackPointer, gs->proj.x );
    CHECK_PUSH( gs, gs->stackPointer, gs->proj.y );
}

/*
 * Read Freedom Vector
 */
static FS_VOID fnt_RFV(fnt_LocalGraphicStateType *gs)
{
    CHECK_PUSH( gs, gs->stackPointer, gs->freedom.x );
    CHECK_PUSH( gs, gs->stackPointer, gs->freedom.y );
}

/*
 * Set Freedom Vector To Projection Vector
 */
static FS_VOID fnt_SFVTPV(fnt_LocalGraphicStateType *gs)
{
    gs->freedom = gs->proj;
    gs->pfProj = ONEVECTOR;
    gs->MovePoint = (FntMoveFunc)fnt_MovePoint;
}

/*
 * fnt_ISECT()
 *
 * Computes the intersection of two lines without using floating point!!
 *
 * (1) Bx + dBx * t0 = Ax + dAx * t1
 * (2) By + dBy * t0 = Ay + dAy * t1
 *
 *  1  =>  (t1 = Bx - Ax + dBx * t0 ) / dAx
 *  +2 =>   By + dBy * t0 = Ay + dAy/dAx * [ Bx - Ax + dBx * t0 ]
 *     => t0 * [dAy/dAx * dBx - dBy = By - Ay - dAy/dAx*(Bx-Ax)
 *     => t0(dAy*DBx - dBy*dAx) = dAx(By - Ay) + dAy(Ax-Bx)
 *     => t0 = [dAx(By-Ay) + dAy(Ax-Bx)] / [dAy*dBx - dBy*dAx]
 *     => t0 = [dAx(By-Ay) - dAy(Bx-Ax)] / [dBx*dAy - dBy*dAx]
 *     t0 = N/D
 *     =>
 *        N = (By - Ay) * dAx - (Bx - Ax) * dAy;
 *        D = dBx * dAy - dBy * dAx;
 *      A simple floating point implementation would only need this, and
 *      the check to see if D is zero.
 *        But to gain speed we do some tricks and aVOID floating point.
 *
 */
static FS_VOID fnt_ISECT(fnt_LocalGraphicStateType *gs)
{
    F26DOT6 N, D;
    FRACT t;
    FS_LONG arg1, arg2;
    F26DOT6 Bx, By, Ax, Ay;
    F26DOT6 dBx, dBy, dAx, dAy;

    {
        fnt_ElementType* element = gs->CE0;
        F26DOT6* stack = gs->stackPointer;

        arg2 = (FS_LONG)CHECK_POP(gs, stack ); /* get one line */
        if (stack == gs->globalGS->stackBase)
        {
            fnt_IllegalInstruction( gs );
            return;
        }
        arg1 = (FS_LONG)CHECK_POP(gs, stack );
        if (stack == gs->globalGS->stackBase)
        {
            fnt_IllegalInstruction( gs );
            return;
        }
        dAx = element->x[arg2] - (Ax = element->x[arg1]);
        dAy = element->y[arg2] - (Ay = element->y[arg1]);

        element = gs->CE1;
        arg2 = (FS_LONG)CHECK_POP(gs, stack ); /* get the other line */
        if (stack == gs->globalGS->stackBase)
        {
            fnt_IllegalInstruction( gs );
            return;
        }
        arg1 = (FS_LONG)CHECK_POP(gs, stack );
        if (stack == gs->globalGS->stackBase)
        {
            fnt_IllegalInstruction( gs );
            return;
        }
        dBx = element->x[arg2] - (Bx = element->x[arg1]);
        dBy = element->y[arg2] - (By = element->y[arg1]);

        arg1 = (FS_LONG)CHECK_POP(gs, stack ); /* get the point number */
        gs->stackPointer = stack;

        /* FS_PRINTF(("dAx=%d dAy=%d dBx=%d dBy=%d\n",dAx,dAy,dBx,dBy)); */

    }
    gs->CE2->f[arg1] |= XMOVED | YMOVED;
    {
        F26DOT6* elementx = gs->CE2->x;
        F26DOT6* elementy = gs->CE2->y;
        if ( dAy == 0 )
        {
            if ( dBx == 0 )
            {
                elementx[arg1] = Bx;
                elementy[arg1] = Ay;
                return;
            }
            N = By - Ay;
            D = -dBy;
        }
        else if ( dAx == 0 )
        {
            if ( dBy == 0 )
            {
                elementx[arg1] = Ax;
                elementy[arg1] = By;
                return;
            }
            N = Bx - Ax;
            D = -dBx;
        }
        else if ( ABS( dAx ) > ABS( dAy ) )
        {
            /* To prevent out of range problems divide both N and D with the max */
            t = FracDiv( dAy, dAx );
            N = (By - Ay) - FracMul( (Bx - Ax), t );
            D = FracMul( dBx, t ) - dBy;
        }
        else
        {
            t = FracDiv( dAx, dAy );
            N = FracMul( (By - Ay), t ) - (Bx - Ax);
            D = dBx - FracMul( dBy, t );
        }

        if ( D )
        {
            if ( ABS( N ) < ABS( D ) )
            {
                /* this is the normal case */
                t = FracDiv( N, D );
                elementx[arg1] = Bx + FracMul( dBx, t );
                elementy[arg1] = By + FracMul( dBy, t );
            }
            else
            {
                if ( N )
                {
                    /* Oh well, invert t and use it instead */
                    t = FracDiv( D, N );
                    /* IF <t> is really small ... this is BIZARRE */
                    elementx[arg1] = Bx + FracDiv( dBx, t );
                    elementy[arg1] = By + FracDiv( dBy, t );
                }
                else
                {
                    elementx[arg1] = Bx;
                    elementy[arg1] = By;
                }
            }
        }
        else
        {
            /* degenerate case: parallel lines, put point in the middle */
            elementx[arg1] = (Bx + (dBx >> 1) + Ax + (dAx >> 1)) >> 1;
            elementy[arg1] = (By + (dBy >> 1) + Ay + (dAy >> 1)) >> 1;
        }
    }
}

/*
 * Load Minimum Distance
 */
static FS_VOID fnt_LMD(fnt_LocalGraphicStateType *gs)
{
    gs->globalGS->localParBlock.minimumDistance = CHECK_POP(gs, gs->stackPointer );
}

/*
 * Load Control Value Table Cut In
 */
static FS_VOID fnt_LWTCI(fnt_LocalGraphicStateType *gs)
{
    gs->globalGS->localParBlock.wTCI = CHECK_POP(gs, gs->stackPointer );
}

/*
 * Load Single Width Cut In
 */
static FS_VOID fnt_LSWCI(fnt_LocalGraphicStateType *gs)
{
    gs->globalGS->localParBlock.sWCI = CHECK_POP(gs, gs->stackPointer );
}

/*
 * Load Single Width , assumes value comes from the original domain, not the cvt or outline
 */
static FS_VOID fnt_LSW(fnt_LocalGraphicStateType *gs)
{
    fnt_GlobalGraphicStateType *globalGS = gs->globalGS;
    fnt_ParameterBlock *pb = &globalGS->localParBlock;

    pb->sW = (FS_SHORT)CHECK_POP(gs, gs->stackPointer );

    /*lint -e571  Warning 571: Warning -- Suspicious cast */
    pb->scaledSW = ScaleFuncCall(globalGS->scaleFuncCVT, &globalGS->scaleCVT, (FS_ULONG)pb->sW );
    /*lint +e571  Warning 571: Warning -- Suspicious cast */
}

static FS_VOID fnt_SetLocalGraphicState(fnt_LocalGraphicStateType *gs)
{
    int arg;
    arg = (int)CHECK_POP(gs, gs->stackPointer );

    switch (gs->opCode)
    {
    case SRP0_CODE:
        gs->Pt0 = (FS_LONG)arg;
        break;
    case SRP1_CODE:
        gs->Pt1 = (FS_LONG)arg;
        break;
    case SRP2_CODE:
        gs->Pt2 = (FS_LONG)arg;
        break;

    case LLOOP_CODE:
        gs->loop = (FS_LONG)arg - 1;
        break;

    case POP_CODE:
        break;
    default:
        break;
    }
}

static FS_VOID fnt_SetElementPtr(fnt_LocalGraphicStateType *gs)
{
    FS_LONG arg;
    fnt_ElementType* element;

    arg = (FS_LONG)CHECK_POP(gs, gs->stackPointer );
    element = &gs->elements[ arg ];

    CHECK_ELEMENT( gs, (FS_LONG)arg );

    switch (gs->opCode)
    {
    case SCES_CODE:
        gs->CE2 = element;
        gs->CE1 = element;
        /* FALLTHROUGH */
    case SCE0_CODE:
        gs->CE0 = element;
        break;
    case SCE1_CODE:
        gs->CE1 = element;
        break;
    case SCE2_CODE:
        gs->CE2 = element;
        break;
    default:
        break;
    }
}

/*
 * Super Round
 */
static FS_VOID fnt_SROUND(fnt_LocalGraphicStateType *gs)
{
    int arg1;
    fnt_ParameterBlock *pb;

    arg1 = (int)CHECK_POP(gs, gs->stackPointer );
    pb = &gs->globalGS->localParBlock;

    fnt_SetRoundValues( gs, arg1, 1 );
    pb->RoundValue = RFI_fnt_SuperRound;
}

/*
 * Super Round
 */
static FS_VOID fnt_S45ROUND(fnt_LocalGraphicStateType *gs)
{
    int arg1;
    fnt_ParameterBlock *pb;

    arg1 = (int)CHECK_POP(gs, gs->stackPointer );
    pb = &gs->globalGS->localParBlock;
    fnt_SetRoundValues( gs, arg1, 0 );
    pb->RoundValue = RFI_fnt_Super45Round;
}

/*
 *    These functions just set a field of the graphics state
 *    They pop no arguments
 */
static FS_VOID fnt_SetRoundState(fnt_LocalGraphicStateType *gs)
{
    FntRoundFunc *rndFunc = &gs->globalGS->localParBlock.RoundValue;

    switch (gs->opCode)
    {
    case RTG_CODE:
        *rndFunc = RFI_fnt_RoundToGrid;
        break;
    case RTHG_CODE:
        *rndFunc = RFI_fnt_RoundToHalfGrid;
        break;
    case RTDG_CODE:
        *rndFunc = RFI_fnt_RoundToDoubleGrid;
        break;
    case ROFF_CODE:
        *rndFunc = RFI_fnt_RoundOff;
        break;
    case RDTG_CODE:
        *rndFunc = RFI_fnt_RoundDownToGrid;
        break;
    case RUTG_CODE:
        *rndFunc = RFI_fnt_RoundUpToGrid;
        break;
    default:
        break;
    }
}


/*
 * Internal support routine for the super rounding routines
 */
static FS_VOID fnt_SetRoundValues(fnt_LocalGraphicStateType *gs, int arg1, int normalRound)
{
    int tmp;
    fnt_ParameterBlock *pb = &gs->globalGS->localParBlock;

    tmp = arg1 & 0xC0;

    if ( normalRound )
    {
        switch ( tmp )
        {
        case 0x00:
            pb->period = (FS_SHORT)(fnt_pixelSize / 2);
            break;
        case 0x40:
            pb->period = (FS_SHORT)fnt_pixelSize;
            break;
        case 0x80:
            pb->period = (FS_SHORT)(fnt_pixelSize * 2);
            break;
        default:
            pb->period = 999; /* Illegal */
        }
        pb->periodMask = ~((FS_USHORT)(pb->period - 1));
    }
    else
    {
        pb->period45 = FRACSQRT2DIV2;
        switch ( tmp )
        {
        case 0x00:
            pb->period45 >>= 1;
            break;
        case 0x40:
            break;
        case 0x80:
            pb->period45 <<= 1;
            break;
        default:
            pb->period45 = 999; /* Illegal */
        }
        tmp = (sizeof(FRACT) * 8 - 2 - fnt_pixelShift);
        pb->period = (FS_SHORT)((pb->period45 + (1L << (tmp - 1))) >> tmp); /*convert from 2.30 to 26.6 */
    }

    tmp = arg1 & 0x30;
    switch ( tmp )
    {
    case 0x00:
        pb->phase = 0;
        break;
    case 0x10:
        pb->phase = (pb->period + 2) >> 2;
        break;
    case 0x20:
        pb->phase = (pb->period + 1) >> 1;
        break;
    case 0x30:
        pb->phase = (pb->period + pb->period + pb->period + 2) >> 2;
        break;
    default:
        break;
    }
    tmp = arg1 & 0x0f;
    if ( tmp == 0 )
    {
        pb->threshold = pb->period - 1;
    }
    else
    {
        pb->threshold = (((FS_USHORT)tmp - 4) * pb->period + 4) >> 3;
    }
}

/*
 * Read Advance Width
 */
static FS_VOID fnt_RAW(fnt_LocalGraphicStateType *gs)
{
    fnt_ElementType* elem = &gs->elements[1];
    F26DOT6* ox = elem->ox;
    FS_LONG index = elem->ep[elem->nc - 1] + 1;        /* lsb point */

    CHECK_PUSH( gs, gs->stackPointer, ox[index + 1] - ox[index] );
}

/*
 * DUPlicate
 */
static FS_VOID fnt_DUP(fnt_LocalGraphicStateType *gs)
{
    F26DOT6 top = gs->stackPointer[-1];
    CHECK_PUSH( gs, gs->stackPointer, top);
}

/*
 * CLEAR stack
 */
static FS_VOID fnt_CLEAR(fnt_LocalGraphicStateType *gs)
{
    gs->stackPointer = gs->globalGS->stackBase;
}

/*
 * SWAP
 */
static FS_VOID fnt_SWAP(fnt_LocalGraphicStateType *gs)
{
    F26DOT6* stack = gs->stackPointer;
    F26DOT6 arg2;
    F26DOT6 arg1;

    arg2 = CHECK_POP(gs, stack );
    if (stack == gs->globalGS->stackBase)
    {
        fnt_IllegalInstruction( gs );
        return;
    }
    arg1 = CHECK_POP(gs, stack );

    CHECK_PUSH( gs, stack, arg2 );
    CHECK_PUSH( gs, stack, arg1 );
}

/*
 * DEPTH
 */
static FS_VOID fnt_DEPTH(fnt_LocalGraphicStateType *gs)
{
    F26DOT6 depth = gs->stackPointer - gs->globalGS->stackBase;
    CHECK_PUSH( gs, gs->stackPointer, depth);
}

/*
 * Copy INDEXed value
 */
static FS_VOID fnt_CINDEX(fnt_LocalGraphicStateType *gs)
{
    FS_LONG arg1;
    F26DOT6 tmp;
    F26DOT6* stack = gs->stackPointer;

    arg1 = (FS_LONG)CHECK_POP(gs, stack );
    tmp = *(stack - arg1 );
    CHECK_PUSH( gs, stack , tmp );
}

/*
 * Move INDEXed value
 */
static FS_VOID fnt_MINDEX(fnt_LocalGraphicStateType *gs)
{
    FS_LONG arg1;
    F26DOT6 tmp, *p;
    F26DOT6* stack = gs->stackPointer;

    arg1 = (FS_LONG)CHECK_POP(gs, stack );
    tmp = *(p = (stack - arg1));
    if ( arg1 )
    {
        do
        {
            *p = *(p + 1);
            p++;
        }
        while ( --arg1 );
        (FS_VOID)CHECK_POP(gs, stack );
    }
    CHECK_PUSH( gs, stack, tmp );
    gs->stackPointer = stack;
}

/*
 *    Rotate element 3 to the top of the stack            <4>
 *    Thanks to Oliver for the obscure code.
 */
static FS_VOID fnt_ROTATE( fnt_LocalGraphicStateType* gs )
{
    F26DOT6 *stack;
    F26DOT6 element1;
    F26DOT6 element2;

    stack = gs->stackPointer;
    element1 = *--stack;
    element2 = *--stack;
    *stack = element1;
    element1 = *--stack;
    *stack = element2;
    *(stack + 2) = element1;
}

F26DOT6 RoundFuncCall(FntRoundFunc f, F26DOT6 xin,
                      F26DOT6 engine, struct fnt_LocalGraphicStateType* gs)
{
    switch (f)
    {
    case RFI_fnt_SuperRound:
        return fnt_SuperRound(xin, engine, gs);
    case RFI_fnt_Super45Round:
        return fnt_Super45Round(xin, engine, gs);
    case RFI_fnt_RoundToGrid:
        return fnt_RoundToGrid(xin, engine, gs);
    case RFI_fnt_RoundToHalfGrid:
        return fnt_RoundToHalfGrid(xin, engine, gs);
    case RFI_fnt_RoundToDoubleGrid:
        return fnt_RoundToDoubleGrid(xin, engine, gs);
    case RFI_fnt_RoundOff:
        return fnt_RoundOff(xin, engine, gs);
    case RFI_fnt_RoundDownToGrid:
        return fnt_RoundDownToGrid(xin, engine, gs);
    case RFI_fnt_RoundUpToGrid:
        return fnt_RoundUpToGrid(xin, engine, gs);
    }
    return(0);
}
/*
 * Move Direct Absolute Point
 */
static FS_VOID fnt_MDAP(fnt_LocalGraphicStateType *gs)
{
    F26DOT6 proj;
    fnt_ElementType* ce0 = gs->CE0;
    fnt_ParameterBlock *pb = &gs->globalGS->localParBlock;
    FS_LONG ptNum;

    ptNum = (FS_LONG)CHECK_POP(gs, gs->stackPointer );
    gs->Pt0 = gs->Pt1 = ptNum;


    if ( BIT0( gs->opCode ) )
    {
        proj = gs->Project( gs, ce0->x[ptNum], ce0->y[ptNum] );
        proj = RoundFuncCall(pb->RoundValue, proj, gs->globalGS->engine[0], gs ) - proj;
    }
    else
        proj = 0;        /* mark the point as touched */

    gs->MovePoint( gs, ce0, ptNum, proj );
}

/*
 * Move Indirect Absolute Point
 */
static FS_VOID fnt_MIAP(fnt_LocalGraphicStateType *gs)
{
    FS_LONG ptNum;
    F26DOT6 newProj, origProj;
    fnt_ElementType* ce0 = gs->CE0;
    fnt_ParameterBlock *pb = &gs->globalGS->localParBlock;

    newProj = gs->GetCVTEntry( gs, (FS_LONG)CHECK_POP(gs, gs->stackPointer ) );
    ptNum = (FS_LONG)CHECK_POP(gs, gs->stackPointer );



    CHECK_POINT(gs, ce0, ptNum);
    gs->Pt0 = gs->Pt1 = ptNum;

    if ( ce0 == gs->elements )        /* twilightzone */
    {
        ce0->x[ptNum] = ce0->ox[ptNum] = VECTORMUL( newProj, gs->proj.x );
        ce0->y[ptNum] = ce0->oy[ptNum] = VECTORMUL( newProj, gs->proj.y );
    }


    origProj = gs->Project( gs, ce0->x[ptNum], ce0->y[ptNum]);

    if ( BIT0( gs->opCode ) )
    {
        F26DOT6 tmp = newProj - origProj;
        if ( tmp < 0 )
            tmp = -tmp;
        if ( tmp > pb->wTCI )
            newProj = origProj;
        newProj = RoundFuncCall(pb->RoundValue, newProj, gs->globalGS->engine[0], gs );
    }


    newProj -= origProj;

    gs->MovePoint( gs, ce0, ptNum, newProj );
}

/*lint -e578  Warning 578: Declaration of symbol '' hides symbol */

/*
 * Interpolate Untouched Points
 */
/*static*/ FS_VOID fnt_IUP(fnt_LocalGraphicStateType *gs)
{
    fnt_ElementType* CE2 = gs->CE2;
    FS_LONG tmp32B;
    F26DOT6 *coord, *oCoord, *ooCoord;
    FS_LONG ctr;
    F26DOT6 dx, dx1, dx2;
    F26DOT6 dlow, dhigh;
    F26DOT6 tmp32, high, low;
    int mask;
    FS_LONG tmp16B;



    if ( gs->opCode & 0x01 )
    {
        /* do x */
        coord = CE2->x;
        oCoord = CE2->ox;
        ooCoord = CE2->oox;
        mask = XMOVED;
    }
    else
    {
        /* do y */
        coord = CE2->y;
        oCoord = CE2->oy;
        ooCoord = CE2->ooy;
        mask = YMOVED;
    }
    for ( ctr = 0; ctr < CE2->nc; ctr++ )
    {
        FS_LONG start = CE2->sp[ctr];
        FS_LONG tmp16 = CE2->ep[ctr];
        while ( !(CE2->f[start] & mask) && start <= tmp16 )
            start++;
        if ( start > tmp16 )
            continue;
        tmp16B = start;
        do
        {
            FS_LONG end;
            tmp16 = end = fnt_NextPt1( start, CE2, ctr );
            while ( !(CE2->f[end] & mask) )
            {
                end = fnt_NextPt1( end, CE2, ctr );
                if ( start == end )
                    break;
            }

            if ( ooCoord[start] < ooCoord[end] )
            {
                dx  = coord[start];
                dx1 = oCoord[start];
                dx2 = ooCoord[start];
                high = oCoord[end];
                dhigh = coord[end] - high;
                tmp32  = coord[end] - dx;
                tmp32B = ooCoord[end] - dx2;
            }
            else
            {
                dx  = coord[end];
                dx1 = oCoord[end];
                dx2 = ooCoord[end];
                high = oCoord[start];
                dhigh = coord[start] - high;
                tmp32  = coord[start] - dx;
                tmp32B = ooCoord[start] - dx2;
            }
            low = dx1;
            dlow = dx - dx1;

            if ( tmp32B )
            {
                if ( tmp32B < 32768L && tmp32 < 32768L )
                {
                    F26DOT6 corr = tmp32B >> 1;
                    while ( tmp16 != end )
                    {
                        F26DOT6 tmp32C = oCoord[tmp16];
                        if ( tmp32C <= low )
                            tmp32C += dlow;
                        else if ( tmp32C >= high )
                            tmp32C += dhigh;
                        else
                        {
                            tmp32C = ooCoord[tmp16];
                            tmp32C -= dx2;
                            tmp32C  = SHORTMUL(tmp32C, tmp32);
                            tmp32C += corr;
                            if ( tmp32C < 32768L )
                                tmp32C = SHORTDIV(tmp32C, tmp32B);
                            else
                                tmp32C /= (FS_SHORT)tmp32B;
                            tmp32C += dx;
                        }
                        coord[tmp16] = tmp32C;
                        tmp16 = fnt_NextPt1( tmp16, CE2, ctr);
                    }
                }
                else
                {
                    FS_FIXED ratio = 0;
                    int firstTime = 1;
                    while ( tmp16 != end )
                    {
                        F26DOT6 tmp32C = oCoord[tmp16];
                        if ( tmp32C <= low )
                            tmp32C += dlow;
                        else if ( tmp32C >= high )
                            tmp32C += dhigh;
                        else
                        {
                            if ( firstTime )
                            {
                                ratio = FixDiv( tmp32, tmp32B );
                                firstTime = 0;
                            }
                            tmp32C = ooCoord[tmp16];
                            tmp32C -= dx2;
                            tmp32C = FixMul( tmp32C, ratio );
                            tmp32C += dx;
                        }

                        coord[tmp16] = tmp32C;
                        tmp16 = fnt_NextPt1( tmp16, CE2, ctr);
                    }
                }
            }
            else
            {
                while ( tmp16 != end )
                {
                    coord[tmp16] += dx - dx1;
                    tmp16 = fnt_NextPt1( tmp16, CE2, ctr);
                }
            }
            start = end;
        }
        while ( start != tmp16B );
    }   /* for ( ctr = 0; ctr < CE2->nc; ctr++ ) */

}

static fnt_ElementType* fnt_SH_Common(fnt_LocalGraphicStateType* gs, F26DOT6* dx, F26DOT6* dy, FS_LONG* point)
{
    F26DOT6 proj;
    FS_LONG pt;
    fnt_ElementType* element;

    if ( BIT0( gs->opCode ) )
    {
        pt = gs->Pt1;
        element = gs->CE0;
    }
    else
    {
        pt = gs->Pt2;
        element = gs->CE1;
    }
    proj = gs->Project( gs, element->x[pt] - element->ox[pt],
                        element->y[pt] - element->oy[pt] );

    if ( gs->pfProj != ONEVECTOR )
    {
        if ( gs->freedom.x )
            *dx = VECTORMULDIV( proj, gs->freedom.x, gs->pfProj );
        if ( gs->freedom.y )
            *dy = VECTORMULDIV( proj, gs->freedom.y, gs->pfProj );
    }
    else
    {
        if ( gs->freedom.x )
            *dx = VECTORMUL( proj, gs->freedom.x );
        if ( gs->freedom.y )
            *dy = VECTORMUL( proj, gs->freedom.y );
    }
    *point = pt;
    return element;
}

static FS_VOID fnt_SHP_Common(fnt_LocalGraphicStateType *gs, F26DOT6 dx, F26DOT6 dy)
{
    fnt_ElementType* CE2 = gs->CE2;
    FS_LONG count = gs->loop;
    for (; count >= 0; --count)
    {
        FS_LONG point;
        point = (FS_LONG)CHECK_POP(gs, gs->stackPointer );
        if ( gs->freedom.x )
        {
            CE2->x[point] += dx;
            CE2->f[point] |= XMOVED;
        }
        if ( gs->freedom.y )
        {
            CE2->y[point] += dy;
            CE2->f[point] |= YMOVED;
        }
    }
    gs->loop = 0;
}

/*
 * SHift Point
 */
static FS_VOID fnt_SHP(fnt_LocalGraphicStateType *gs)
{
    F26DOT6 dx, dy;
    FS_LONG point;

    fnt_SH_Common(gs, &dx, &dy, &point);
    fnt_SHP_Common(gs, dx, dy);
}

/*
 * SHift Contour
 */
static FS_VOID fnt_SHC(fnt_LocalGraphicStateType *gs)
{
    fnt_ElementType *element;
    F26DOT6 dx, dy;
    FS_LONG contour, point;

    {
        F26DOT6 x, y;
        FS_LONG pt;
        element = fnt_SH_Common(gs, &x, &y, &pt);
        point = pt;
        dx = x;
        dy = y;
    }
    contour = (FS_LONG)CHECK_POP(gs, gs->stackPointer );

    CHECK_CONTOUR(gs, gs->CE2, contour);

    {
        SHORTFRACT fvx = gs->freedom.x;
        SHORTFRACT fvy = gs->freedom.y;
        fnt_ElementType* CE2 = gs->CE2;
        FS_LONG currPt = CE2->sp[contour];
        FS_LONG count = CE2->ep[contour] - currPt;
        CHECK_POINT(gs, CE2, currPt + count);
        for (; count >= 0; --count)
        {
            if ( currPt != point || element != CE2 )
            {
                if ( fvx )
                {
                    CE2->x[currPt] += dx;
                    CE2->f[currPt] |= XMOVED;
                }
                if ( fvy )
                {
                    F26DOT6 tempdy = 0;
                    CE2->y[currPt] += dy - tempdy;
                    CE2->f[currPt] |= YMOVED;
                }
            }
            currPt++;
        }
    }
}

/*
 * SHift Element            <4>
 */
static FS_VOID fnt_SHE(fnt_LocalGraphicStateType *gs)
{
    fnt_ElementType *element;
    F26DOT6 dx, dy;
    FS_LONG firstPoint, origPoint, lastPoint, arg1;

    {
        F26DOT6 x, y;
        element = fnt_SH_Common(gs, &x, &y, &origPoint);
        dx = x;
        dy = y;
    }

    arg1 = (FS_LONG)CHECK_POP(gs, gs->stackPointer );
    CHECK_ELEMENT(gs, (FS_LONG)arg1);

    lastPoint = gs->elements[arg1].ep[gs->elements[arg1].nc - 1];
    CHECK_POINT(gs, &gs->elements[arg1], lastPoint);
    firstPoint  = gs->elements[arg1].sp[0];
    CHECK_POINT(gs, &gs->elements[arg1], firstPoint);

    /*** changed this            <4>
        do {
            if ( origPoint != firstPoint || element != &gs->elements[arg1] ) {
                if ( gs->freedom.x ) {
                    gs->elements[ arg1 ].x[firstPoint] += dx;
                    gs->elements[ arg1 ].f[firstPoint] |= XMOVED;
                }
                if ( gs->freedom.y ) {
                    gs->elements[ arg1 ].y[firstPoint] += dy;
                    gs->elements[ arg1 ].f[firstPoint] |= YMOVED;
                }
            }
            firstPoint++;
        } while ( firstPoint <= lastPoint );
    ***** To this ? *********/

    if (element != &gs->elements[arg1])        /* we're in different zones */
        origPoint = -1;                        /* no need to skip orig point */
    {
        if ( gs->freedom.x )
        {
            F26DOT6 deltaX = dx;
            F26DOT6* x = &gs->elements[ arg1 ].x[firstPoint];
            FS_BYTE* f = &gs->elements[ arg1 ].f[firstPoint]; /* FA - 02-06-06 */
            FS_LONG count = origPoint - firstPoint - 1;
            for (; count >= 0; --count )
            {
                *x++ += deltaX;
                *f++ |= XMOVED;  /* FA - 02-06-06 */
            }
            if (origPoint == -1)
                count = lastPoint - firstPoint;
            else
            {
                count = lastPoint - origPoint - 1;
                x++;                            /* skip origPoint */
                f++;    /* FA - 02-06-06 */
            }
            for (; count >= 0; --count )
            {
                *x++ += deltaX;
                *f++ |= XMOVED;  /* FA - 02-06-06 */
            }
        }
        if ( gs->freedom.y )        /* fix me semore */
        {
            F26DOT6 deltaY = dy;
            F26DOT6* y = &gs->elements[ arg1 ].y[firstPoint];
            FS_BYTE* f = &gs->elements[ arg1 ].f[firstPoint];
            FS_LONG count = origPoint - firstPoint - 1;
            for (; count >= 0; --count )
            {
                *y++ += deltaY;
                *f++ |= YMOVED;  /* FA - 02-06-06 */

            }
            if (origPoint == -1)
                count = lastPoint - firstPoint;
            else
            {
                count = lastPoint - origPoint - 1;
                y++, f++;                        /* skip origPoint */
            }
            /*    mask |= YMOVED; */  /* FA - 02-06-06 */
            for (; count >= 0; --count )
            {
                *y++ += deltaY;
                *f++ |= YMOVED;  /* FA - 02-06-06 */
            }
        }
    }
}

/*
 * SHift point by PIXel amount
 */
static FS_VOID fnt_SHPIX(fnt_LocalGraphicStateType *gs)
{
    F26DOT6 proj, dx = 0, dy = 0;

    proj = CHECK_POP(gs, gs->stackPointer );
    if ( gs->freedom.x )
        dx = VECTORMUL( proj, gs->freedom.x );
    if ( gs->freedom.y )
        dy = VECTORMUL( proj, gs->freedom.y );

    fnt_SHP_Common(gs, dx, dy);
}

/*
 * Interpolate Point
 */
static FS_VOID fnt_IP(fnt_LocalGraphicStateType *gs)
{
    F26DOT6 oldRange, currentRange;
    FS_LONG RP1 = gs->Pt1;
    FS_LONG pt2 = gs->Pt2;
    fnt_ElementType* CE0 = gs->CE0;
    FS_BOOLEAN twilight = CE0 == gs->elements || gs->CE1 == gs->elements || gs->CE2 == gs->elements;
    {
        currentRange = gs->Project( gs, gs->CE1->x[pt2] - CE0->x[RP1],
                                    gs->CE1->y[pt2] - CE0->y[RP1] );
        if ( twilight )
            oldRange = gs->OldProject( gs, gs->CE1->ox[pt2] - CE0->ox[RP1],
                                       gs->CE1->oy[pt2] - CE0->oy[RP1] );
        else
            oldRange = gs->OldProject( gs, gs->CE1->oox[pt2] - CE0->oox[RP1],
                                       gs->CE1->ooy[pt2] - CE0->ooy[RP1] );
    }
    for (; gs->loop >= 0; --gs->loop)
    {
        FS_LONG arg1;
        F26DOT6 tmp;

        if (gs->stackPointer <= gs->globalGS->stackBase)
            break; /* bad hint */

        arg1 = (FS_LONG)CHECK_POP(gs, gs->stackPointer );
        if ( twilight )
            tmp = gs->OldProject( gs, gs->CE2->ox[arg1] - CE0->ox[RP1],
                                  gs->CE2->oy[arg1] - CE0->oy[RP1] );
        else
            tmp = gs->OldProject( gs, gs->CE2->oox[arg1] - CE0->oox[RP1],
                                  gs->CE2->ooy[arg1] - CE0->ooy[RP1] );

        if ( oldRange )
            tmp = LongMulDiv( currentRange, tmp, oldRange );
        /* Otherwise => desired projection = old projection */

        tmp -= gs->Project( gs, gs->CE2->x[arg1] - CE0->x[RP1],
                            gs->CE2->y[arg1] - CE0->y[RP1] ); /* delta = desired projection - current projection */

        gs->MovePoint( gs, gs->CE2, arg1, tmp );


    }
    gs->loop = 0;
}

/*
 * Move Stack Indirect Relative Point
 */
static FS_VOID fnt_MSIRP( fnt_LocalGraphicStateType* gs )
{
    fnt_ElementType* CE0;
    fnt_ElementType* CE1;
    FS_LONG Pt0;
    F26DOT6 dist; /* distance   */
    FS_LONG pt2; /* point #    */

    CE0 = gs->CE0;
    CE1 = gs->CE1;
    Pt0 = gs->Pt0;
    dist = CHECK_POP(gs, gs->stackPointer ); /* distance   */
    pt2 = (FS_LONG)CHECK_POP(gs, gs->stackPointer ); /* point #    */

    if ( CE1 == gs->elements )
    {
        CE1->ox[pt2] = CE0->ox[Pt0] + VECTORMUL( dist, gs->proj.x );
        CE1->oy[pt2] = CE0->oy[Pt0] + VECTORMUL( dist, gs->proj.y );
        CE1->x[pt2] = CE1->ox[pt2];
        CE1->y[pt2] = CE1->oy[pt2];
    }
    dist -= gs->Project( gs, CE1->x[pt2] - CE0->x[Pt0],
                         CE1->y[pt2] - CE0->y[Pt0] );

    gs->MovePoint( gs, CE1, pt2, dist );
    gs->Pt1 = Pt0;
    gs->Pt2 = pt2;
    if ( BIT0( gs->opCode ) )
    {
        gs->Pt0 = pt2; /* move the reference point */
    }
}

/*
 * Align Relative Point
 */
static FS_VOID fnt_ALIGNRP(fnt_LocalGraphicStateType *gs)
{
    fnt_ElementType* ce1 = gs->CE1;
    F26DOT6 pt0x = gs->CE0->x[gs->Pt0];
    F26DOT6 pt0y = gs->CE0->y[gs->Pt0];

    for (; gs->loop >= 0; --gs->loop)
    {
        FS_LONG ptNum;
        F26DOT6 proj;

        ptNum = (FS_LONG)CHECK_POP(gs, gs->stackPointer );
        proj = -gs->Project( gs, ce1->x[ptNum] - pt0x, ce1->y[ptNum] - pt0y );
        gs->MovePoint( gs, ce1, ptNum, proj );
    }
    gs->loop = 0;
}


/*
 * Align Two Points ( by moving both of them )
 */
static FS_VOID fnt_ALIGNPTS(fnt_LocalGraphicStateType *gs)
{
    FS_LONG pt1, pt2;
    F26DOT6 move1, dist;

    pt2  = (FS_LONG)CHECK_POP(gs, gs->stackPointer ); /* point # 2   */
    pt1  = (FS_LONG)CHECK_POP(gs, gs->stackPointer ); /* point # 1   */


    /* We do not have to check if we are in character element zero (the twilight zone)
       since both points already have to have defined values before we execute this instruction */
    dist = gs->Project( gs, gs->CE0->x[pt2] - gs->CE1->x[pt1],
                        gs->CE0->y[pt2] - gs->CE1->y[pt1] );

    move1 = dist >> 1;
    gs->MovePoint( gs, gs->CE0, pt1, move1 );
    gs->MovePoint( gs, gs->CE1, pt2, move1 - dist ); /* make sure the total movement equals tmp32 */
}

/*
 * Set Angle Weight
 */
static FS_VOID fnt_SANGW(fnt_LocalGraphicStateType *gs)
{
    gs->globalGS->localParBlock.angleWeight = (FS_SHORT)CHECK_POP(gs, gs->stackPointer );
}

/*
 * Flip Point
 */
static FS_VOID fnt_FLIPPT(fnt_LocalGraphicStateType *gs)
{
    FS_BYTE *onCurve = gs->CE0->onCurve;
    F26DOT6* stack = gs->stackPointer;
    FS_LONG count = gs->loop;

    for (; count >= 0; --count)
    {
        FS_LONG point;
        point = (FS_LONG)CHECK_POP(gs, stack );
        onCurve[ point ] ^= ONCURVE;
    }
    gs->loop = 0;

    gs->stackPointer = stack;
}

/*
 * Flip On a Range
 */
static FS_VOID fnt_FLIPRGON(fnt_LocalGraphicStateType *gs)
{
    FS_LONG lo, hi;
    FS_LONG count;
    FS_BYTE *onCurve = gs->CE0->onCurve;
    F26DOT6* stack = gs->stackPointer;

    hi = (FS_LONG)CHECK_POP(gs, stack );
    CHECK_POINT( gs, gs->CE0, hi );
    lo = (FS_LONG)CHECK_POP(gs, stack );
    CHECK_POINT( gs, gs->CE0, lo );

    onCurve += lo;
    for (count = (FS_LONG)(hi - lo); count >= 0; --count)
        *onCurve++ |= ONCURVE;
    gs->stackPointer = stack;
}

/*
 * Flip Off a Range
 */
static FS_VOID fnt_FLIPRGOFF(fnt_LocalGraphicStateType *gs)
{
    FS_LONG lo, hi;
    FS_LONG count;
    FS_BYTE *onCurve = gs->CE0->onCurve;

    hi = (FS_LONG)CHECK_POP(gs, gs->stackPointer );
    CHECK_POINT( gs, gs->CE0, hi );
    lo = (FS_LONG)CHECK_POP(gs, gs->stackPointer );
    CHECK_POINT( gs, gs->CE0, lo );

    onCurve += lo;
    for (count = (hi - lo); count >= 0; --count)
        *onCurve++ &= ~ONCURVE;
}

/* 4/22/90 rwb - made more general
 * Sets lower 16 flag bits of ScanControl variable.  Sets scanContolIn if we are in one
 * of the preprograms; else sets scanControlOut.
 *
 * stack: value => -;
 *
 */
static FS_VOID fnt_SCANCTRL(fnt_LocalGraphicStateType *gs)
{
    fnt_GlobalGraphicStateType *globalGS = gs->globalGS;
    fnt_ParameterBlock *pb = &globalGS->localParBlock;

    pb->scanControl = (pb->scanControl & 0xFFFF0000L) | CHECK_POP(gs, gs->stackPointer );
}

/* 5/24/90 rwb
 * Sets upper 16 bits of ScanControl variable. Sets scanContolIn if we are in one
 * of the preprograms; else sets scanControlOut.
 */

static FS_VOID fnt_SCANTYPE(fnt_LocalGraphicStateType *gs)
{
    fnt_GlobalGraphicStateType *globalGS;
    fnt_ParameterBlock *pb;
    int value;
    FS_LONG *scanPtr;

    globalGS = gs->globalGS;
    pb = &globalGS->localParBlock;
    value = (int)CHECK_POP(gs, gs->stackPointer );
    scanPtr = &(pb->scanControl);

    if        ( value == 0 )  *scanPtr &= 0xFFFF;
    else if ( value == 1 )    *scanPtr = (*scanPtr & 0xFFFFL) | STUBCONTROL;
    else if ( value == 2 )    *scanPtr = (*scanPtr & 0xFFFFL) | NODOCONTROL;
}

/* 6/28/90 rwb
 * Sets instructControl flags in global graphic state.  Only legal in pre program.
 * A selector is used to choose the flag to be set.
 * Bit0 - NOGRIDFITFLAG - if set, then 1type instructions are not executed.
 *         A font may want to use the preprogram to check if the glyph is rotated or
 *          transformed in such a way that it is better to not gridfit the glyphs.
 * Bit1 - DEFAULTFLAG - if set, then changes in localParameterBlock variables in the
 *        globalGraphics state made in the CVT preprogram are not copied back into
 *        the defaultParameterBlock.  So, the original default values are the starting
 *        values for each glyph.
 *
 * stack: value, selector => -;
 *
 */
static FS_VOID fnt_INSTCTRL(fnt_LocalGraphicStateType *gs)  /* <13> */
{
    fnt_GlobalGraphicStateType *globalGS;
    FS_LONG *ic;
    int selector;
    FS_LONG value;

    globalGS = gs->globalGS;
    ic = &globalGS->localParBlock.instructControl;
    selector     = (int)CHECK_POP(gs, gs->stackPointer );
    value     = (FS_LONG)CHECK_POP(gs, gs->stackPointer );


    if ( globalGS->init )
    {
        if ( selector == 1 )
        {
            *ic &= ~NOGRIDFITFLAG;
            *ic |= (value & NOGRIDFITFLAG);
        }
        else if ( selector == 2 )
        {
            *ic &= ~DEFAULTFLAG;
            *ic |= (value & DEFAULTFLAG);
        }
    }
}


/****************************************************************/
/* The AA hint is used by iType to control automatic grid       */
/* alignment as follows:                                        */
/*  AA1: Latin autohinting for stroke fonts                     */
/*  AA2: Not used (formerly Asian autohinting for stroke fonts) */
/*  AA3: Latin autohinting for monospace stroke fonts           */
/*  AA4: Autohinting for Arabic stroke fonts                    */
/*  AA5: MAZ autohinting for stroke and outline fonts           */
/*  AA252: compressed delta hints for MAZ and non-MAZ fonts     */
/*  AA253: compressed delta hints for stroke and outline fonts  */
static FS_VOID fnt_AA(fnt_LocalGraphicStateType *gs)
{
    int which;
    FS_ULONG fontflags, stateflags;
    fnt_ElementType *elementPtr;
#ifdef FS_EDGE_HINTS
    FS_BYTE is_stik = 0;
#endif

    fontflags = gs->globalGS->rtgah_data.fontflags;
    stateflags = gs->globalGS->rtgah_data.stateflags;

    /* pop the argument for all cases */
    which = CHECK_POP(gs, gs->stackPointer);

    /* we know autohinting is on
       we know it's gray
       we know the glyph has no other hints */
    if (which == 11)
    {
        rtgah(gs);
        return;
    }

    /* return if hinting not turned on */
    if (stateflags & FLAGS_NO_HINTS)
        return;

#ifdef FS_EDGE_HINTS
    if (fontflags & FONTFLAG_STIK)
        is_stik = (gs->elements[GLYPHELEMENT].nc &&
                   !(gs->elements[GLYPHELEMENT].onCurve[0] & OUTLINE_CHAR));

    if ((which == 5))
    {
        gs->globalGS->maz_data.MAZdeltaHorz = APPLYMAZDELTASBEFORE;
        gs->globalGS->maz_data.MAZdeltaVert = APPLYMAZDELTASBEFORE;
        if (is_stik)
            ADFAutohintMAZStroke(gs);
        else
            ADFAutohintMAZOutline(gs);

        return;
    }
    else if (which == 6)
    {
        gs->globalGS->maz_data.MAZdeltaHorz = APPLYMAZDELTASAFTER;
        gs->globalGS->maz_data.MAZdeltaVert = APPLYMAZDELTASAFTER;
        if (is_stik)
            ADFAutohintMAZStroke(gs);
        else
            ADFAutohintMAZOutline(gs);

        return;
    }
    else if (which == 7)
    {
        fnt_SVTCA_0(gs);
        BAZpositionStems(gs);

        return;
    }
    else if (which == 8)
    {
        /* save x/y setting */
        int reset = 0;
        if (gs->proj.x != 0)
            reset = 1;
        fnt_SVTCA_0(gs);
        if (is_stik)
            ADFAutohintBAZStroke(gs);
        else
            ADFAutohintBAZOutline(gs);
        if (reset)
            fnt_SVTCA_1(gs);

        return;
    }

    else if (which == 9)
    {
        ADFMAZKeepInBox(gs);

        return;
    }

    if (which == 250)
    {
        do_deltas_250(gs);
        return;
    }

    if (which == 251)
    {
        do_deltas_251(gs);
        return;
    }
#else
    if ( (( which >= 5 ) && ( which <= 9 )) || (which == 250) || (which == 251) )
    {
        edgehints_err(gs);
        return;
    }
#endif /* FS_EDGE_HINTS */

    if (which == 252)
    {
        do_deltas_252(gs);
        return;
    }

    if (which == 253)
    {
        do_deltas_253(gs);
        return;
    }

    if ( !(fontflags & FONTFLAG_NEW_AA_ON))
        return;

    /* return if it is a non-stik font */
    if (!(fontflags & FONTFLAG_STIK))
        return;

    /* return if it is an outline character */
    elementPtr = gs->CE0;
    if (elementPtr->f && (elementPtr->f[0] & OUTLINE_CHAR))
        return;

#ifdef FS_STIK
    {
        FS_BOOLEAN int_sw;
        if (!(stateflags & FLAGS_GRAYSCALE) ||
                (fontflags & FONTFLAG_NEW_AA_ON) ||
                (stateflags & (FLAGS_EMBOSSED | FLAGS_ENGRAVED | FLAGS_OUTLINED | FLAGS_OUTLINED_2PIXEL | \
                               FLAGS_OUTLINED_UNFILLED)))
            int_sw = 1; /* non-integer stroke width */
        else
            int_sw = 0;

        switch (which)
        {
        case 1:
            autohint_latin(gs, int_sw);
            break;
            /* not used for this version
            case 2:
            autohint_asian(gs);
            break;
            case 3:
            autohint_asian_reflines(gs);
            break;*/
        case 3:
            autohint_mono(gs, int_sw); /* monospace (Greek, Cyrillic) */
            break;
        case 4:
            autohint_arabic(gs, int_sw);
            break;
            /* note cases 5, 252, and 253 are handled earlier in this function */
        default:
            autohint_other(gs, int_sw);
            break;
        }
    }
#else
    return;
#endif
}

/*
 *    Called by fnt_PUSHB and fnt_NPUSHB
 */
static FS_VOID fnt_PushSomeStuff(fnt_LocalGraphicStateType *gs, FS_LONG count, FS_BOOLEAN pushBytes)
{
    F26DOT6* stack = gs->stackPointer;
    FS_BYTE* instr = gs->insPtr;
    if (pushBytes)
        for (--count; count >= 0; --count)
            CHECK_PUSH( gs, stack, GETBYTE( instr ));
    else
    {
        for (--count; count >= 0; --count)
        {
            FS_SHORT word = *instr++;
            CHECK_PUSH( gs, stack, (FS_SHORT)((word << 8) + *instr++));
        }
    }
    gs->stackPointer = stack;
    gs->insPtr = instr;
}

/*
 * PUSH Bytes        <3>
 */
static FS_VOID fnt_PUSHB(fnt_LocalGraphicStateType *gs)
{
    fnt_PushSomeStuff(gs, gs->opCode - 0xb0 + 1, 1);
}

/*
 * N PUSH Bytes
 */
static FS_VOID fnt_NPUSHB(fnt_LocalGraphicStateType *gs)
{
    fnt_PushSomeStuff(gs, GETBYTE( gs->insPtr ), 1);
}

/*
 * PUSH Words        <3>
 */
static FS_VOID fnt_PUSHW(fnt_LocalGraphicStateType *gs)
{
    fnt_PushSomeStuff(gs, gs->opCode - 0xb8 + 1, 0);
}

/*
 * N PUSH Words
 */
static FS_VOID fnt_NPUSHW(fnt_LocalGraphicStateType *gs)
{
    fnt_PushSomeStuff(gs, GETBYTE( gs->insPtr ), 0);
}

/*
 * Write Store
 */
static FS_VOID fnt_WS(fnt_LocalGraphicStateType *gs)
{
    F26DOT6 storage;
    FS_LONG storeIndex;

    storage = CHECK_POP(gs, gs->stackPointer );
    storeIndex = (FS_LONG)CHECK_POP(gs, gs->stackPointer );

    CHECK_STORAGE( gs, (FS_LONG)storeIndex );

    gs->globalGS->store[ storeIndex ] = storage;
}

/*
 * Read Store
 */
static FS_VOID fnt_RS(fnt_LocalGraphicStateType *gs)
{
    FS_LONG storeIndex;

    storeIndex = (FS_LONG)CHECK_POP(gs, gs->stackPointer );
    CHECK_STORAGE( gs, (FS_LONG)storeIndex );
    CHECK_PUSH( gs, gs->stackPointer, gs->globalGS->store[storeIndex] );
}

/*
 * Write Control Value Table from outLine, assumes the value comes from the outline domain
 */
static FS_VOID fnt_WCVT(fnt_LocalGraphicStateType *gs)
{
    FS_LONG cvtIndex;
    F26DOT6 cvtValue;

    cvtValue = CHECK_POP(gs, gs->stackPointer );
    cvtIndex = (FS_LONG)CHECK_POP(gs, gs->stackPointer );

    CHECK_CVT( gs, (FS_LONG)cvtIndex );
    if(cvtIndex >= gs->globalGS->cvtCount)
        return;

    gs->globalGS->controlValueTable[ cvtIndex ] = cvtValue;

    /* The BASS outline is in the transformed domain but the cvt is not so apply the inverse transform */
    if ( cvtValue )
    {
        F26DOT6 tmpCvt;
        tmpCvt = gs->GetCVTEntry( gs, cvtIndex );
        if ( tmpCvt != 0  &&  tmpCvt != cvtValue )
        {
            gs->globalGS->controlValueTable[ cvtIndex ] = FixMul( cvtValue,  FixDiv( cvtValue, tmpCvt ) );
        }
    }
}

/*
 * Write Control Value Table From Original Domain, assumes the value comes from the original domain, not the cvt or outline
 */
static FS_VOID fnt_WCVTFOD(fnt_LocalGraphicStateType *gs)
{
    FS_LONG cvtIndex;
    F26DOT6 cvtValue;
    fnt_GlobalGraphicStateType *globalGS = gs->globalGS;

    cvtValue = CHECK_POP(gs, gs->stackPointer );
    cvtIndex = (FS_LONG)CHECK_POP(gs, gs->stackPointer );
    CHECK_CVT( gs, (FS_LONG)cvtIndex );
    if(cvtIndex >= gs->globalGS->cvtCount)
        return;

    globalGS->controlValueTable[ cvtIndex ] = ScaleFuncCall(globalGS->scaleFuncCVT, &globalGS->scaleCVT, cvtValue );
}



/*
 * Read Control Value Table
 */
static FS_VOID fnt_RCVT(fnt_LocalGraphicStateType *gs)
{
    FS_LONG cvtIndex, value;

    cvtIndex = (FS_LONG)CHECK_POP(gs, gs->stackPointer );
    value = gs->GetCVTEntry(gs, cvtIndex);
    /*** FS_PRINTF(("RVCT(%d) = %08x\n",cvtIndex,value)); ***/
    CHECK_PUSH( gs, gs->stackPointer, value );
}

/*
 * Read Coordinate
 */
static FS_VOID fnt_RC(fnt_LocalGraphicStateType *gs)
{
    FS_LONG pt;
    fnt_ElementType *element;
    F26DOT6 proj;

    pt = (FS_LONG)CHECK_POP(gs, gs->stackPointer );
    element = gs->CE2;

    {

        if ( BIT0( gs->opCode ) )
            proj = gs->OldProject( gs, element->ox[pt], element->oy[pt] );
        else
        {
            proj = gs->Project( gs, element->x[pt], element->y[pt] );
        }
    }

    CHECK_PUSH( gs, gs->stackPointer, proj );
}

/*
 * Write Coordinate
 */
static FS_VOID fnt_WC(fnt_LocalGraphicStateType *gs)
{
    F26DOT6 proj, coord;
    FS_LONG pt;
    fnt_ElementType *element;

    coord = CHECK_POP(gs, gs->stackPointer );/* value */
    pt = (FS_LONG)CHECK_POP(gs, gs->stackPointer );/* point */
    element = gs->CE2;

    proj = gs->Project( gs, element->x[pt],  element->y[pt] );
    proj = coord - proj;



    gs->MovePoint( gs, element, pt, proj );

    if (element == gs->elements)        /* twilightzone */
    {
        element->ox[pt] = element->x[pt];
        element->oy[pt] = element->y[pt];
    }
}


/*
 * Measure Distance
 */
static FS_VOID fnt_MD(fnt_LocalGraphicStateType *gs)
{
    FS_LONG pt1, pt2;
    F26DOT6 proj, *stack = gs->stackPointer;
    fnt_GlobalGraphicStateType *globalGS = gs->globalGS;

    pt2 = (FS_LONG)CHECK_POP(gs, stack );
    if (stack == globalGS->stackBase)
    {
        fnt_IllegalInstruction( gs );
        return;
    }

    pt1 = (FS_LONG)CHECK_POP(gs, stack );

    if ( BIT0( gs->opCode - MD_CODE ) )
    {
        proj  = gs->OldProject( gs, gs->CE0->oox[pt1] - gs->CE1->oox[pt2],
                                gs->CE0->ooy[pt1] - gs->CE1->ooy[pt2] );
        proj = ScaleFuncCall(globalGS->scaleFuncCVT, &globalGS->scaleCVT, proj );
    }
    else
    {
        proj  = gs->Project( gs, gs->CE0->x[pt1] - gs->CE1->x[pt2],
                             gs->CE0->y[pt1] - gs->CE1->y[pt2] );

    }

    CHECK_PUSH( gs, stack, proj );
    gs->stackPointer = stack;
}

/*
 * Measure Pixels Per EM
 */
static FS_VOID fnt_MPPEM(fnt_LocalGraphicStateType *gs)
{
    FS_USHORT ppem;
    fnt_GlobalGraphicStateType *globalGS = gs->globalGS;

    ppem = globalGS->pixelsPerEm;

    if ( !globalGS->identityTransformation )
        ppem = (FS_USHORT)FixMul( (FS_FIXED)ppem, fnt_GetCVTScale( gs ) );

    CHECK_PUSH( gs, gs->stackPointer, ppem );
}

/*
 * Measure Point Size
 */
static FS_VOID fnt_MPS(fnt_LocalGraphicStateType *gs)
{
    CHECK_PUSH( gs, gs->stackPointer, gs->globalGS->pointSize );
}

/*
 * Get Miscellaneous info: version number, rotated, stretched     <6>
 * Version number is 8 bits.  This is version 0x01 : 5/1/90
 *
 */

static FS_VOID fnt_GETINFO( fnt_LocalGraphicStateType* gs )
{
    fnt_GlobalGraphicStateType *globalGS;
    int selector;
    int info;

    globalGS = gs->globalGS;
    selector = (int)CHECK_POP(gs, gs->stackPointer );
    info = 0;

    if ( selector & 1)                                /* version */
        info |= 1;
    if ( (selector & 2) && (globalGS->non90DegreeTransformation & 0x1) )
        info |= ROTATEDGLYPH;
    if ( (selector & 4) &&  (globalGS->non90DegreeTransformation & 0x2))
        info |= STRETCHEDGLYPH;
    CHECK_PUSH( gs, gs->stackPointer, info );
}

/*
 * FLIP ON
 */
static FS_VOID fnt_FLIPON(fnt_LocalGraphicStateType *gs)
{
    gs->globalGS->localParBlock.autoFlip = 1;
}

/*
 * FLIP OFF
 */
static FS_VOID fnt_FLIPOFF(fnt_LocalGraphicStateType *gs)
{
    gs->globalGS->localParBlock.autoFlip = 0;
}


static FS_VOID fnt_DEBUG(fnt_LocalGraphicStateType* gs)
{
    (FS_VOID)CHECK_POP(gs, gs->stackPointer );
}


/*
 *    This guy is here to save space for simple instructions
 *    that pop two arguments and push one back on.
 */
static FS_VOID fnt_BinaryOperand(fnt_LocalGraphicStateType* gs)
{
    F26DOT6* stack;
    F26DOT6 arg2;
    F26DOT6 arg1;

    stack = gs->stackPointer;
    arg2 = CHECK_POP(gs, stack );
    arg1 = CHECK_POP(gs, stack );


    switch (gs->opCode)
    {
    case LT_CODE:
        BOOLEANPUSH( stack, arg1 < arg2 );
        break;
    case LTEQ_CODE:
        BOOLEANPUSH( stack, arg1 <= arg2 );
        break;
    case GT_CODE:
        BOOLEANPUSH( stack, arg1 > arg2 );
        break;
    case GTEQ_CODE:
        BOOLEANPUSH( stack, arg1 >= arg2 );
        break;
    case EQ_CODE:
        BOOLEANPUSH( stack, arg1 == arg2 );
        break;
    case NEQ_CODE:
        BOOLEANPUSH( stack, arg1 != arg2 );
        break;

    case AND_CODE:
        BOOLEANPUSH( stack, arg1 && arg2 );
        break;
    case OR_CODE:
        BOOLEANPUSH( stack, arg1 || arg2 );
        break;

    case ADD_CODE:
        CHECK_PUSH( gs, stack, arg1 + arg2 );
        break;
    case SUB_CODE:
        CHECK_PUSH( gs, stack, arg1 - arg2 );
        break;
    case MUL_CODE:
        CHECK_PUSH( gs, stack, Mul26Dot6( arg1, arg2 ));
        break;
    case DIV_CODE:
        CHECK_PUSH( gs, stack, Div26Dot6NoRound( arg1, arg2 ));
        break;
    case MAX_CODE:
        if (arg1 < arg2) arg1 = arg2;
        CHECK_PUSH( gs, stack, arg1 );
        break;
    case MIN_CODE:
        if (arg1 > arg2) arg1 = arg2;
        CHECK_PUSH( gs, stack, arg1 );
        break;
    default:
        break;
    }
    gs->stackPointer = stack;
    CHECK_STACK(gs);
}

static FS_VOID fnt_UnaryOperand(fnt_LocalGraphicStateType* gs)
{
    F26DOT6* stack;
    F26DOT6 arg;
    FS_BYTE opCode;


    stack = gs->stackPointer;
    arg = CHECK_POP(gs, stack );
    opCode = gs->opCode;

    switch (opCode)
    {
    case ODD_CODE:
    case EVEN_CODE:
        arg = fnt_RoundToGrid( arg, 0L, 0 );
        arg >>= fnt_pixelShift;
        if ( opCode == ODD_CODE )
            arg++;
        BOOLEANPUSH( stack, (arg & 1) == 0 );
        break;
    case NOT_CODE:
        BOOLEANPUSH( stack, !arg );
        break;

    case ABS_CODE:
        CHECK_PUSH( gs, stack, arg > 0 ? arg : -arg );
        break;
    case NEG_CODE:
        CHECK_PUSH( gs, stack, -arg );
        break;

    case CEILING_CODE:
        arg += fnt_pixelSize - 1;
        /* FALLTHROUGH */
    case FLOOR_CODE:
        arg &= ~(fnt_pixelSize - 1);
        CHECK_PUSH( gs, stack, arg );
        break;
    default:
        break;
    }
    gs->stackPointer = stack;
    CHECK_STACK(gs);
}

/*
 * Internal function for fnt_IF(), and fnt_FDEF()
 */
static FS_VOID fnt_SkipPushCrap(fnt_LocalGraphicStateType *gs)
{
    FS_BYTE opCode = gs->opCode;
    FS_BYTE* instr = gs->insPtr;
    FS_LONG count;

    if ( opCode == NPUSHB_CODE )
    {
        count = (FS_LONG) * instr++;
        instr += count;
    }
    else if ( opCode == NPUSHW_CODE )
    {
        count = (FS_LONG) * instr++;
        instr += count + count;
    }
    else if ( opCode >= PUSHB_START && opCode <= PUSHB_END )
    {
        count = (FS_LONG)(opCode - PUSHB_START + 1);
        instr += count;
    }
    else if ( opCode >= PUSHW_START && opCode <= PUSHW_END )
    {
        count = (FS_LONG)(opCode - PUSHW_START + 1);
        instr += count + count;
    }
    gs->insPtr = instr;
}

/*
 * IF
 */
static FS_VOID fnt_IF(fnt_LocalGraphicStateType *gs)
{
    int level;
    FS_BYTE opCode;

    if ( ! CHECK_POP(gs, gs->stackPointer ) )
    {
        /* Now skip instructions */
        for ( level = 1; level; )
        {
            /* level = # of "ifs" minus # of "endifs" */
            if ( (gs->opCode = opCode = *gs->insPtr++) == EIF_CODE )
            {
                level--;
            }
            else if ( opCode == IF_CODE )
            {
                level++;
            }
            else if ( opCode == ELSE_CODE )
            {
                if ( level == 1 ) break;
            }
            else
                fnt_SkipPushCrap( gs );
        }
    }
}

/*
 *    ELSE for the IF
 */
static FS_VOID fnt_ELSE( fnt_LocalGraphicStateType* gs )
{
    int level;
    FS_BYTE opCode;

    for ( level = 1; level; )
    {
        /* level = # of "ifs" minus # of "endifs" */
        if ( (gs->opCode = opCode = *gs->insPtr++) == EIF_CODE )   /* EIF */
        {
            level--;
        }
        else if ( opCode == IF_CODE )
        {
            level++;
        }
        else
            fnt_SkipPushCrap( gs );
    }
}


/*
 * End IF
 */
static FS_VOID fnt_EIF( fnt_LocalGraphicStateType* gs)
{
    (void)gs; /*unused*/
}


/*
 * Jump Relative
 */
static FS_VOID fnt_JMPR( fnt_LocalGraphicStateType* gs )
{
    FS_LONG offset;

    offset = (FS_LONG)CHECK_POP(gs, gs->stackPointer );
    offset--; /* since the interpreter post-increments the IP */
    gs->insPtr += offset;
}

/*
 * Jump Relative On 1
 */
static FS_VOID fnt_JROT(fnt_LocalGraphicStateType *gs)
{
    FS_LONG offset;
    F26DOT6* stack = gs->stackPointer;

    if ( CHECK_POP(gs, stack ) )
    {
        offset = (FS_LONG)CHECK_POP(gs, stack );
        --offset; /* since the interpreter post-increments the IP */
        gs->insPtr += offset;
    }
    else
    {
        --stack;/* same as POP */
    }
    gs->stackPointer = stack;
}

/*
 * Jump Relative On 0
 */
static FS_VOID fnt_JROF(fnt_LocalGraphicStateType *gs)
{
    FS_LONG offset;
    F26DOT6* stack = gs->stackPointer;

    if ( CHECK_POP(gs, stack ) )
    {
        --stack;/* same as POP */
    }
    else
    {
        offset = (FS_LONG)CHECK_POP(gs, stack );
        offset--; /* since the interpreter post-increments the IP */
        gs->insPtr += offset;
    }
    gs->stackPointer = stack;
}

/*
 * ROUND
 */
static FS_VOID fnt_ROUND(fnt_LocalGraphicStateType *gs)
{
    F26DOT6 arg1;
    fnt_ParameterBlock *pb = &gs->globalGS->localParBlock;

    arg1 = CHECK_POP(gs, gs->stackPointer );

    CHECK_RANGE( gs->opCode, 0x68, 0x6B );

    arg1 = RoundFuncCall(pb->RoundValue, arg1, gs->globalGS->engine[gs->opCode - 0x68], gs);
    CHECK_PUSH( gs, gs->stackPointer , arg1 );
}

/*
 * No ROUND
 */
static FS_VOID fnt_NROUND(fnt_LocalGraphicStateType *gs)
{
    F26DOT6 arg1;

    arg1 = CHECK_POP(gs, gs->stackPointer );

    CHECK_RANGE( gs->opCode, 0x6C, 0x6F );

    arg1 = fnt_RoundOff( arg1, gs->globalGS->engine[gs->opCode - 0x6c], 0 );
    CHECK_PUSH( gs, gs->stackPointer , arg1 );
}

/*
 * An internal function used by MIRP an MDRP.
 */
static F26DOT6 fnt_CheckSingleWidth(F26DOT6 value, fnt_LocalGraphicStateType *gs)
{
    F26DOT6 delta, scaledSW;
    fnt_ParameterBlock *pb = &gs->globalGS->localParBlock;

    scaledSW = gs->GetSingleWidth( gs );

    if ( value >= 0 )
    {
        delta = value - scaledSW;
        if ( delta < 0 )    delta = -delta;
        if ( delta < pb->sWCI )    value = scaledSW;
    }
    else
    {
        value = -value;
        delta = value - scaledSW;
        if ( delta < 0 )    delta = -delta;
        if ( delta < pb->sWCI )    value = scaledSW;
        value = -value;
    }
    return value;
}


/*
 * Move Direct Relative Point
 */
static FS_VOID fnt_MDRP(fnt_LocalGraphicStateType *gs)
{
    FS_LONG pt1, pt0 = gs->Pt0;
    F26DOT6 tmp, tmpC;
    fnt_ElementType *element = gs->CE1;
    fnt_GlobalGraphicStateType *globalGS = gs->globalGS;
    fnt_ParameterBlock *pb = &globalGS->localParBlock;

    pt1 = (FS_LONG)CHECK_POP(gs, gs->stackPointer );



    CHECK_POINT(gs, gs->CE0, pt0);
    CHECK_POINT(gs, element, pt1);

    if ( gs->CE0 == gs->elements || element == gs->elements )
    {
        tmp  = gs->OldProject( gs, element->ox[pt1] - gs->CE0->ox[pt0],
                               element->oy[pt1] - gs->CE0->oy[pt0] );
    }
    else
    {
        F26DOT6 dx = element->oox[pt1] - gs->CE0->oox[pt0];
        F26DOT6 dy = element->ooy[pt1] - gs->CE0->ooy[pt0];


        if (gs->proj.x == 0 /*qwu 06-06-04  ||
            (globalGS->scaleX.N == globalGS->scaleY.N &&
             globalGS->scaleX.D == globalGS->scaleY.D &&
             globalGS->scaleX.shift == globalGS->scaleY.shift &&
             globalGS->scaleX.scl == globalGS->scaleY.scl) qwu 06-06-04*/)
        {
            tmp = gs->OldProject(gs, dx, dy);
            /*qwu 06-06-04 */
            /* tmp = globalGS->scaleFuncCVT(&globalGS->scaleCVT,tmp);*/
            tmp = ScaleFuncCall(globalGS->scaleFuncY, &globalGS->scaleY, tmp); /*qwu 06-06-04 */
        }
        else
        {
            if (gs->proj.y == 0)
            {
                tmp = gs->OldProject(gs, dx, dy);
                tmp = ScaleFuncCall(globalGS->scaleFuncX, &globalGS->scaleX, tmp);
            }
            else
            {
                /*qwu 06-06-04 */
                if (gs->OldProject == gs->Project)
                {
                    dx = VECTORMUL( dx, gs->proj.x);
                    dy = VECTORMUL( dy, gs->proj.y);
                    dx = ScaleFuncCall(globalGS->scaleFuncX, &globalGS->scaleX, dx);
                    dy = ScaleFuncCall(globalGS->scaleFuncY, &globalGS->scaleY, dy);
                    tmp = dx + dy;
                }
                else  /*qwu 06-06-04 */
                {
                    dx = VECTORMUL( dx, gs->oldProj.x);
                    dy = VECTORMUL( dy, gs->oldProj.y);
                    dx = ScaleFuncCall(globalGS->scaleFuncX, &globalGS->scaleX, dx);
                    dy = ScaleFuncCall(globalGS->scaleFuncY, &globalGS->scaleY, dy);
                    tmp = dx + dy;
                }
            }
        }
    }

    if ( pb->sWCI )
    {
        tmp = fnt_CheckSingleWidth( tmp, gs );
    }

    tmpC = tmp;
    if ( BIT2( gs->opCode )  )
    {
        tmp = RoundFuncCall(pb->RoundValue, tmp, globalGS->engine[gs->opCode & 0x03], gs );
    }
    else
    {
        tmp = fnt_RoundOff( tmp, globalGS->engine[gs->opCode & 0x03], 0 );
    }


    if ( BIT3( gs->opCode ) )
    {
        F26DOT6 tmpB = pb->minimumDistance;
        if ( tmpC >= 0 )
        {
            if ( tmp < tmpB )
            {
                tmp = tmpB;
            }
        }
        else
        {
            tmpB = -tmpB;
            if ( tmp > tmpB )
            {
                tmp = tmpB;
            }
        }
    }

    tmpC = gs->Project( gs, element->x[pt1] - gs->CE0->x[pt0],
                        element->y[pt1] - gs->CE0->y[pt0] );
    tmp -= tmpC;

    gs->MovePoint( gs, element, pt1, tmp );
    gs->Pt1 = pt0;
    gs->Pt2 = pt1;
    if ( BIT4( gs->opCode ) )
    {
        gs->Pt0 = pt1; /* move the reference point */
    }
}

/*
 * Move Indirect Relative Point
 */
static FS_VOID fnt_MIRP(fnt_LocalGraphicStateType *gs)
{
    FS_LONG ptNum;
    F26DOT6 tmp, tmpB, tmpC;
    fnt_GlobalGraphicStateType *globalGS = gs->globalGS;
    fnt_ParameterBlock *pb = &gs->globalGS->localParBlock;

    tmp = gs->GetCVTEntry( gs, (FS_LONG)CHECK_POP(gs, gs->stackPointer ) );
    ptNum = (FS_LONG)CHECK_POP(gs, gs->stackPointer );



    if ( pb->sWCI )
    {
        tmp = fnt_CheckSingleWidth( tmp, gs );
    }

    if ( gs->CE1 == gs->elements )
    {
        gs->CE1->ox[ptNum] = gs->CE0->ox[gs->Pt0];
        gs->CE1->oy[ptNum] = gs->CE0->oy[gs->Pt0];
        gs->CE1->ox[ptNum] += VECTORMUL( tmp, gs->proj.x );
        gs->CE1->oy[ptNum] += VECTORMUL( tmp, gs->proj.y );
        gs->CE1->x[ptNum] = gs->CE1->ox[ptNum];
        gs->CE1->y[ptNum] = gs->CE1->oy[ptNum];
    }

    tmpC  = gs->OldProject( gs, gs->CE1->ox[ptNum] - gs->CE0->ox[gs->Pt0],
                            gs->CE1->oy[ptNum] - gs->CE0->oy[gs->Pt0] );
    if ( pb->autoFlip )
    {
        if ( ((FS_LONG)(tmpC ^ tmp)) < 0 )
        {
            tmp = -tmp; /* Do the auto flip */
        }
    }

    if ( BIT2( gs->opCode )  )
    {
        tmpB = tmp - tmpC;
        if ( tmpB < 0 )    tmpB = -tmpB;
        if ( tmpB > pb->wTCI )    tmp = tmpC;
        tmp = RoundFuncCall(pb->RoundValue, tmp, globalGS->engine[gs->opCode & 0x03], gs );
    }
    else
    {
        tmp = fnt_RoundOff( tmp, globalGS->engine[gs->opCode & 0x03], 0 );
    }


    if ( BIT3( gs->opCode ) )
    {
        tmpB = gs->globalGS->localParBlock.minimumDistance;
        if ( tmpC >= 0 )
        {
            if ( tmp < tmpB )
            {
                tmp = tmpB;
            }
        }
        else
        {
            tmpB = -tmpB;
            if ( tmp > tmpB )
            {
                tmp = tmpB;
            }
        }
    }

    tmpC  = gs->Project( gs, gs->CE1->x[ptNum] - gs->CE0->x[gs->Pt0],
                         gs->CE1->y[ptNum] - gs->CE0->y[gs->Pt0] );

    tmp  -= tmpC;

    gs->MovePoint( gs, gs->CE1, ptNum, tmp );
    gs->Pt1 = gs->Pt0;
    gs->Pt2 = ptNum;
    if ( BIT4( gs->opCode ) )
    {
        gs->Pt0 = ptNum; /* move the reference point */
    }
}

/*
 * CALL a function
 */
static FS_VOID fnt_CALL(fnt_LocalGraphicStateType *gs)
{
    fnt_funcDef *funcDef;
    FS_BYTE *ins;
    fnt_GlobalGraphicStateType *globalGS;
    FS_LONG arg;

    globalGS = gs->globalGS;
    arg = (FS_LONG)CHECK_POP(gs, gs->stackPointer );
    if (arg >= globalGS->maxp->maxFunctionDefs)
    {
        gs->error = 1;
        return;
    }

    if (globalGS->funcDef == NULL)
    {
        gs->error = 1;
        return;
    }

    CHECK_FDEF( gs, (FS_LONG)arg );
    funcDef = &globalGS->funcDef[ arg ];

    CHECK_PROGRAM(funcDef->pgmIndex);
    if (funcDef->pgmIndex >= MAXPREPROGRAMS)
    {
        gs->error = 1;
        return;
    }
    ins = globalGS->pgmList[ funcDef->pgmIndex ];

    CHECK_ASSERTION( (ins != 0) );

    if (!ins) return;

    ins += funcDef->start;


    fnt_InnerExecute( gs, ins, ins + funcDef->length);
}

/*
 * Function DEFinition
 */
static FS_VOID fnt_FDEF(fnt_LocalGraphicStateType *gs)
{
    fnt_funcDef *funcDef;
    FS_BYTE* program, *funcStart;
    fnt_GlobalGraphicStateType *globalGS;
    FS_LONG arg;

    globalGS = gs->globalGS;
    arg = (FS_LONG)CHECK_POP(gs, gs->stackPointer );
    CHECK_FDEF( gs, (FS_LONG)arg );
    if (arg >= globalGS->maxp->maxFunctionDefs)
    {
        gs->error = 1;
        return;
    }

    funcDef = &globalGS->funcDef[ arg ];
    if (funcDef == NULL)
    {
        gs->error = 1;
        return;
    }
    program = globalGS->pgmList[ funcDef->pgmIndex = globalGS->pgmIndex ];

    CHECK_PROGRAM(funcDef->pgmIndex);
    CHECK_ASSERTION( globalGS->funcDef != 0 );
    CHECK_ASSERTION( globalGS->pgmList[funcDef->pgmIndex] != 0 );

    funcDef->start = gs->insPtr - program;
    funcStart = gs->insPtr;
    while ( (gs->opCode = *gs->insPtr++) != ENDF_CODE )
        fnt_SkipPushCrap( gs );

    funcDef->length = (FS_USHORT)(gs->insPtr - funcStart - 1); /* don't execute ENDF */
}

/*
 * LOOP while CALLing a function
 */
static FS_VOID fnt_LOOPCALL(fnt_LocalGraphicStateType *gs)
{
    FS_BYTE *start, *stop;
    fnt_funcDef *funcDef;
    FS_LONG arg;
    FS_LONG loop;
    fnt_GlobalGraphicStateType *globalGS;

    globalGS = gs->globalGS;
    arg = (FS_LONG)CHECK_POP(gs, gs->stackPointer );
    CHECK_FDEF( gs, (FS_LONG)arg );
    if (arg >= globalGS->maxp->maxFunctionDefs)
    {
        gs->error = 1;
        return;
    }

    funcDef    = &(globalGS->funcDef[ arg ]);
    {
        FS_BYTE* ins;

        CHECK_PROGRAM(funcDef->pgmIndex);
        ins = globalGS->pgmList[ funcDef->pgmIndex ];

        start = &ins[funcDef->start];
        stop  = &ins[funcDef->start + funcDef->length];    /* funcDef->end -> funcDef->length <4> */
    }
    loop = (FS_LONG)CHECK_POP(gs, gs->stackPointer );
    for (--loop; loop >= 0; --loop )
        fnt_InnerExecute( gs, start, stop );
}
/*lint +e578  Warning 578: Declaration of symbol '' hides symbol */

/*
 *    This guy returns the index of the given opCode, or 0 if not found <4>
 */
static fnt_instrDef* fnt_FindIDef(fnt_LocalGraphicStateType* gs, FS_BYTE opCode)
{
    fnt_GlobalGraphicStateType* globalGS = gs->globalGS;
    FS_LONG count = globalGS->instrDefCount;
    fnt_instrDef* instrDef = globalGS->instrDef;
    for (--count; count >= 0; instrDef++, --count)
        if (instrDef->opCode == opCode)
            return instrDef;
    return 0;
}

/*
 *    This guy gets called for opCodes that has been patch by the font's IDEF    <4>
 *    or if they have never been defined.  If there is no corresponding IDEF,
 *    flag it as an illegal instruction.
 */
static FS_VOID fnt_IDefPatch( fnt_LocalGraphicStateType* gs )
{
    fnt_instrDef* instrDef = fnt_FindIDef(gs, gs->opCode);
    if (instrDef == 0)
        fnt_IllegalInstruction( gs );
    else
    {
        FS_BYTE* program;

        CHECK_PROGRAM(instrDef->pgmIndex);
        program = gs->globalGS->pgmList[ instrDef->pgmIndex ];

        program += instrDef->start;
        fnt_InnerExecute( gs, program, program + instrDef->length);
    }
}

/*
 * Instruction DEFinition    <4>
 */
static FS_VOID fnt_IDEF( fnt_LocalGraphicStateType* gs )
{
    FS_BYTE opCode;
    fnt_instrDef* instrDef;
    FS_LONG pgmIndex;
    FS_BYTE* program;
    FS_BYTE* instrStart;

    opCode = (FS_BYTE)CHECK_POP(gs, gs->stackPointer );
    instrDef = fnt_FindIDef(gs, opCode);
    pgmIndex = (FS_LONG)gs->globalGS->pgmIndex;
    program = gs->globalGS->pgmList[ pgmIndex ];
    instrStart = gs->insPtr;

    CHECK_PROGRAM(pgmIndex);

    if (!instrDef)
        instrDef = gs->globalGS->instrDef + gs->globalGS->instrDefCount++;

    instrDef->pgmIndex = (FS_BYTE)pgmIndex;
    instrDef->opCode = opCode;        /* this may or may not have been set */
    instrDef->start = gs->insPtr - program;

    /* If FONTPROGRAM references a user-defined hinting function (opcodes 0xa2-0xaf),
     * this font is not a MTI font, so set flag indicating that the "generic" hinting
     * functions are to be used
     */
    if ( (instrDef->pgmIndex == FONTPROGRAM) && (gs->globalGS->udFuncType == ITYPE_UD_FUNCTIONS) )
    {
        if ( (instrDef->opCode >= 0xA2) && (instrDef->opCode <= 0xAf) )
            gs->globalGS->udFuncType = GENERIC_UD_FUNCTIONS;
    }
    while ( (gs->opCode = *gs->insPtr++) != ENDF_CODE )
        fnt_SkipPushCrap( gs );

    instrDef->length = (FS_USHORT)(gs->insPtr - instrStart - 1); /* don't execute ENDF */
}

/*lint +e522 Warning -- Highest operation, function 'oops', lacks side-effects     */

/*
 * UnTouch Point
 */
static FS_VOID fnt_UTP(fnt_LocalGraphicStateType *gs)
{
    FS_LONG point;
    FS_BYTE* f;

    point = (FS_LONG)CHECK_POP(gs, gs->stackPointer );
    f = gs->CE0->f;

    if ( gs->freedom.x )
    {
        f[point] &= ~XMOVED;
    }
    if ( gs->freedom.y )
    {
        f[point] &= ~YMOVED;
    }
}

/*
 * Set Delta Base
 */
static FS_VOID fnt_SDB(fnt_LocalGraphicStateType *gs)
{
    gs->globalGS->localParBlock.deltaBase = (FS_SHORT)CHECK_POP(gs, gs->stackPointer );
}

/*
 * Set Delta Shift
 */
static FS_VOID fnt_SDS(fnt_LocalGraphicStateType *gs)
{
    gs->globalGS->localParBlock.deltaShift = (FS_SHORT)CHECK_POP(gs, gs->stackPointer );
}

/*
 * DeltaEngine, internal support routine
 */
static FS_VOID fnt_DeltaEngine(fnt_LocalGraphicStateType *gs, FntMoveFunc doIt, FS_SHORT base, FS_SHORT shift)
{
    FS_LONG tmp;
    FS_LONG fakePixelsPerEm, ppem;
    FS_LONG aim, high;
    FS_LONG tmp32;


    /* Find the beginning of data pairs for this particular size */
    high = (FS_LONG)CHECK_POP(gs, gs->stackPointer ) << 1; /* -= number of pops required */

    gs->stackPointer -= high;



    /* same as fnt_MPPEM() */
    tmp32 = gs->globalGS->pixelsPerEm;

    if ( !gs->globalGS->identityTransformation )
    {
        FS_FIXED scale;

        scale = fnt_GetCVTScale( gs );
        tmp32 = FixMul( tmp32, scale );
    }

    fakePixelsPerEm = tmp32 - base;



    if ( fakePixelsPerEm >= 16 || fakePixelsPerEm < 0 ) return; /* Not within exception range */
    fakePixelsPerEm <<= 4;

    aim = 0;
    tmp = high >> 1;
    tmp &= ~1;
    while ( tmp > 2 )
    {
        ppem  = (FS_LONG)gs->stackPointer[ aim + tmp ]; /* [ ppem << 4 | exception ] */
        if ( (ppem & ~0x0f) < fakePixelsPerEm )
        {
            aim += tmp;
        }
        tmp >>= 1;
        tmp &= ~1;
    }

    while ( aim < high )
    {
        ppem  = (FS_LONG)gs->stackPointer[ aim ]; /* [ ppem << 4 | exception ] */
        if ( (tmp = (ppem & ~0x0f)) == fakePixelsPerEm )
        {
            /* We found an exception, go ahead and apply it */
            tmp  = ppem & 0xf; /* 0 ... 15 */
            tmp -= tmp >= 8 ? 7 : 8; /* -8 ... -1, 1 ... 8 */
            tmp <<= fnt_pixelShift; /* convert to pixels */
            tmp >>= shift; /* scale to right size */

            doIt( gs, gs->CE0,
                  (FS_LONG)gs->stackPointer[aim + 1] /* point number */,
                  tmp /* the delta */ );
        }
        else if ( tmp > fakePixelsPerEm )
        {
            break; /* we passed the data */
        }
        aim += 2;
    }
}


/*
 * DELTAP1
 */
static FS_VOID fnt_DELTAP1(fnt_LocalGraphicStateType *gs)
{
    fnt_ParameterBlock *pb = &gs->globalGS->localParBlock;

    fnt_DeltaEngine( gs, gs->MovePoint, pb->deltaBase, pb->deltaShift );
}

/*
 * DELTAP2
 */
static FS_VOID fnt_DELTAP2(fnt_LocalGraphicStateType *gs)
{
    fnt_ParameterBlock *pb = &gs->globalGS->localParBlock;

    fnt_DeltaEngine( gs, gs->MovePoint, (FS_SHORT)(pb->deltaBase + 16), pb->deltaShift );
}

/*
 * DELTAP3
 */
static FS_VOID fnt_DELTAP3(fnt_LocalGraphicStateType *gs)
{
    fnt_ParameterBlock *pb = &gs->globalGS->localParBlock;

    fnt_DeltaEngine( gs, gs->MovePoint, (FS_SHORT)(pb->deltaBase + 32), pb->deltaShift );
}

/*
 * DELTAC1
 */
static FS_VOID fnt_DELTAC1(fnt_LocalGraphicStateType *gs)
{
    fnt_ParameterBlock *pb = &gs->globalGS->localParBlock;
    fnt_DeltaEngine( gs, (FntMoveFunc)fnt_ChangeCvt, pb->deltaBase, pb->deltaShift );
}

/*
 * DELTAC2
 */
static FS_VOID fnt_DELTAC2(fnt_LocalGraphicStateType *gs)
{
    fnt_ParameterBlock *pb = &gs->globalGS->localParBlock;
    fnt_DeltaEngine( gs, (FntMoveFunc)fnt_ChangeCvt, (FS_SHORT)(pb->deltaBase + 16), pb->deltaShift );
}

/*
 * DELTAC3
 */
static FS_VOID fnt_DELTAC3(fnt_LocalGraphicStateType *gs)
{
    fnt_ParameterBlock *pb = &gs->globalGS->localParBlock;
    fnt_DeltaEngine( gs, (FntMoveFunc)fnt_ChangeCvt, (FS_SHORT)(pb->deltaBase + 32), pb->deltaShift );
}

/****************************************************************/

/* The following function returns an integer representing the next bitCount bits on the
    stack. The phase is a number from 0 (representing the 0x8000 bit) through 15 (representing
    the 0x0001 bit). If there are not enough bits in the current word to satisfy the
    request then the next word will be popped and the phase adjusted accordingly. */
static FS_LONG get_bitfield(FS_LONG bitCount, FS_LONG *phase, fnt_LocalGraphicStateType *gs)
{
    F26DOT6 value = gs->stackPointer[-1];
    FS_LONG mask = (1L << bitCount) - 1, maskShift, retVal;

    if ((bitCount + *phase) <= 16)
    {
        /* The current value contains enough bits to satisfy this request. */
        maskShift = 16 - (bitCount + *phase);
        mask <<= maskShift;
        retVal = (value & mask) >> maskShift;
        *phase += bitCount;

        if (*phase == 16)
        {
            (void) CHECK_POP(gs, gs->stackPointer);
            *phase = 0;
        }
    }
    else
    {
        /* The current value does not contain enough bits to satisfy this request. */
        FS_ULONG    value32 = (FS_ULONG) ((value << 16) | (gs->stackPointer[-2] & 0x0000FFFFL));

        maskShift = 32 - (bitCount + *phase);
        mask <<= maskShift;
        retVal = (value32 & mask) >> maskShift;
        *phase += (bitCount - 16);
        (void) CHECK_POP(gs, gs->stackPointer);
    }

    return retVal;
}   /* get_bitfield */

#ifdef FS_EDGE_HINTS
static FS_LONG get_huffman_opcode_251(FS_LONG *phase, fnt_LocalGraphicStateType *gs)
{
    switch (get_bitfield(2, phase, gs))
    {
    case 0:
        if (get_bitfield(1, phase, gs) == 1) return 1;
        if (get_bitfield(1, phase, gs) == 1) return 3;
        return get_bitfield(1, phase, gs) ? 11 : 10;
    case 1:
        return 2;
    case 2:
        return 4;
    default:
        if (get_bitfield(1, phase, gs) == 1) return 0;
        if (get_bitfield(1, phase, gs) == 0) return 5;
        if (get_bitfield(1, phase, gs) == 0) return 12;
        switch (get_bitfield(2, phase, gs))
        {
        case 0:
            return 7;
        case 1:
            return 8;
        case 2:
            return 6;
        default:
            return 9;
        }   /* end switch */
    }   /* end switch */
} /* get_huffman_opcode_251 */

static FS_LONG get_huffman_operand_251_0(FS_LONG *phase, fnt_LocalGraphicStateType *gs)
{
    switch (get_bitfield(3, phase, gs))
    {
    case 0:
        return get_bitfield(1, phase, gs) ? 3 : 11;
    case 1:
        return 6;
    case 2:
        if (get_bitfield(1, phase, gs) == 1) return 4;
        if (get_bitfield(1, phase, gs) == 1) return 15;
        if (get_bitfield(1, phase, gs) == 1) return 64;
        if (get_bitfield(1, phase, gs) == 1) return 80;
        switch (get_bitfield(2, phase, gs))
        {
        case 0:
            return 96;
        case 1:
            return get_bitfield(1, phase, gs) ? 112 : 256;
        case 2:
            switch (get_bitfield(2, phase, gs))
            {
            case 0:
                return 128;
            case 1:
                return 144;
            case 2:
                return 160;
            default:
                return 176;
            } /* end switch */
        default:
            switch (get_bitfield(2, phase, gs))
            {
            case 0:
                return 192;
            case 1:
                return 208;
            case 2:
                return 224;
            default:
                return 240;
            } /* end switch */
        } /* end switch */
    case 3:
        return get_bitfield(1, phase, gs) ? 1 : 7;
    case 4:
        if (get_bitfield(1, phase, gs) == 0) return 5;
        return get_bitfield(1, phase, gs) ? 14 : 48;
    case 5:
        if (get_bitfield(1, phase, gs) == 0) return 32;
        return get_bitfield(1, phase, gs) ? 2 : 10;
    case 6:
        return 16;
    default:
        switch (get_bitfield(2, phase, gs))
        {
        case 0:
            return 12;
        case 1:
            return 13;
        case 2:
            return 8;
        default:
            return 9;
        } /* end switch */
    }
} /* get_huffman_operand_251_0 */

static FS_LONG get_huffman_operand_251_1(FS_LONG *phase, fnt_LocalGraphicStateType *gs)
{
    if (get_bitfield(1, phase, gs) == 1) return 1;
    switch (get_bitfield(2, phase, gs))
    {
    case 0:
        if (get_bitfield(1, phase, gs) == 1) return 3;
        switch (get_bitfield(2, phase, gs))
        {
        case 0:
            return 11;
        case 1:
            return 4;
        case 2:
            switch (get_bitfield(2, phase, gs))
            {
            case 0:
                return get_bitfield(1, phase, gs) ? 13 : 5;
            case 1:
                return 6;
            case 2:
                return 9;
            default:
                return get_bitfield(1, phase, gs) ? 32 : 14;
            } /* end switch */
        default:
            if (get_bitfield(1, phase, gs) == 0) return 12;
            switch (get_bitfield(2, phase, gs))
            {
            case 0:
                return 48;
            case 1:
                return 64;
            case 2:
                return 80;
            default:
                return 96;
            } /* end switch */
        } /* end switch */
    case 1:
        return 7;
    case 2:
        return 15;
    default:
        if (get_bitfield(1, phase, gs) == 1) return 2;
        if (get_bitfield(1, phase, gs) == 1) return 8;
        switch (get_bitfield(2, phase, gs))
        {
        case 0:
            switch (get_bitfield(2, phase, gs))
            {
            case 0:
                return 112;
            case 1:
                return 128;
            case 2:
                return 144;
            default:
                return 160;
            } /* end switch */
        case 1:
            switch (get_bitfield(2, phase, gs))
            {
            case 0:
                return 176;
            case 1:
                return 192;
            case 2:
                return 208;
            default:
                return 224;
            } /* end switch */
        case 2:
            return 16;
        default:
            if (get_bitfield(1, phase, gs) == 1) return 10;
            return get_bitfield(1, phase, gs) ? 256 : 240;
        } /* end switch */
    } /* end switch */
} /* get_huffman_operand_251_1 */

static FS_LONG get_huffman_operand_251_2(FS_LONG *phase, fnt_LocalGraphicStateType *gs)
{
    switch (get_bitfield(3, phase, gs))
    {
    case 0:
        return get_bitfield(1, phase, gs) ? 7 : 15;
    case 1:
        if (get_bitfield(1, phase, gs) == 0) return 12;
        return get_bitfield(1, phase, gs) ? 9 : 10;
    case 2:
        return 3;
    case 3:
        if (get_bitfield(1, phase, gs) == 1) return 6;
        return get_bitfield(1, phase, gs) ? 8 : 16;
    case 4:
        return 2;
    case 5:
        if (get_bitfield(1, phase, gs) == 0) return 11;
        return get_bitfield(1, phase, gs) ? 13 : 14;
    case 6:
        return get_bitfield(1, phase, gs) ? 5 : 4;
    default:
        return 1;
    }
} /* get_huffman_operand_251_2 */

static FS_LONG get_huffman_operand_251_3(FS_LONG *phase, fnt_LocalGraphicStateType *gs)
{
    switch (get_bitfield(3, phase, gs))
    {
    case 0:
        if (get_bitfield(1, phase, gs) == 1) return 11;
        if (get_bitfield(1, phase, gs) == 1) return 12;
        switch (get_bitfield(2, phase, gs))
        {
        case 0:
            return 13;
        case 1:
            return 14;
        case 2:
            return 15;
        default:
            return 16;
        } /* end switch */
    case 1:
        return get_bitfield(1, phase, gs) ? 8 : 10;
    case 2:
        return 2;
    case 3:
        return 4;
    case 4:
        return 3;
    case 5:
        return get_bitfield(1, phase, gs) ? 7 : 9;
    case 6:
        return 1;
    default:
        return get_bitfield(1, phase, gs) ? 5 : 6;
    }
} /* get_huffman_operand_251_3 */

static FS_LONG get_huffman_operand_251_5(FS_LONG *phase, fnt_LocalGraphicStateType *gs)
{
    /* NOTE: unlike the other 251 operand functions, this one adds 2 and not just 1 */
    if (get_bitfield(1, phase, gs) == 1) return 2;
    if (get_bitfield(1, phase, gs) == 1) return 3;
    if (get_bitfield(1, phase, gs) == 0) return 4;
    if (get_bitfield(1, phase, gs) == 1) return 5;
    if (get_bitfield(1, phase, gs) == 0) return 6;
    switch (get_bitfield(3, phase, gs))
    {
    case 0:
        return 14;
    case 1:
        return 15;
    case 2:
        return 16;
    case 3:
        return 17;
    case 4:
        return 7;
    case 5:
        return get_bitfield(1, phase, gs) ? 9 : 8;
    case 6:
        return get_bitfield(1, phase, gs) ? 11 : 10;
    default:
        return get_bitfield(1, phase, gs) ? 13 : 12;
    }
} /* get_huffman_operand_251_5 */

static FS_LONG get_huffman_operand_251_7(FS_LONG *phase, fnt_LocalGraphicStateType *gs)
{
    /* NOTE: unlike the other 251 operand functions, this one does not add 1 to the result */
    if (get_bitfield(1, phase, gs) == 1) return 2;
    switch (get_bitfield(2, phase, gs))
    {
    case 0:
        switch (get_bitfield(2, phase, gs))
        {
        case 0:
            return 6;
        case 1:
            return 7;
        case 2:
            return 8;
        default:
            return 9;
        } /* end switch */
    case 1:
        switch (get_bitfield(2, phase, gs))
        {
        case 0:
            return 10;
        case 1:
            return 11;
        case 2:
            return 12;
        default:
            return 13;
        } /* end switch */
    case 2:
        return 1;
    default:
        switch (get_bitfield(2, phase, gs))
        {
        case 0:
            return 14;
        case 1:
            return 15;
        case 2:
            return get_bitfield(1, phase, gs) ? 3 : 0;
        default:
            return get_bitfield(1, phase, gs) ? 5 : 4;
        } /* end switch */
    } /* end switch */
} /* get_huffman_operand_251_7 */

static FS_LONG get_huffman_operand_251_8(FS_LONG *phase, fnt_LocalGraphicStateType *gs)
{
    switch (get_bitfield(2, phase, gs))
    {
    case 0:
        return 12;
    case 1:
        if (get_bitfield(1, phase, gs) == 0) return 2;
        if (get_bitfield(1, phase, gs) == 0) return 15;
        if (get_bitfield(1, phase, gs) == 0) return 3;
        if (get_bitfield(1, phase, gs) == 0) return 4;
        return get_bitfield(1, phase, gs) ? 6 : 5;
    case 2:
        return get_bitfield(1, phase, gs) ? 13 : 16;
    default:
        if (get_bitfield(1, phase, gs) == 1) return 1;
        if (get_bitfield(1, phase, gs) == 0) return 14;
        if (get_bitfield(1, phase, gs) == 1) return 11;
        switch (get_bitfield(2, phase, gs))
        {
        case 0:
            return 7;
        case 1:
            return 8;
        case 2:
            return 9;
        default:
            return 10;
        } /* end switch */
    } /* end switch */
} /* get_huffman_operand_251_8 */

static FS_LONG get_huffman_operand_251_9(FS_LONG *phase, fnt_LocalGraphicStateType *gs)
{
    switch (get_bitfield(3, phase, gs))
    {
    case 0:
        return 15;
    case 1:
        return 2;
    case 2:
        switch (get_bitfield(2, phase, gs))
        {
        case 0:
            return get_bitfield(1, phase, gs) ? 5 : 11;
        case 1:
            switch (get_bitfield(2, phase, gs))
            {
            case 0:
                return 6;
            case 1:
                return 8;
            case 2:
                return 9;
            default:
                return 10;
            } /* end switch */
        case 2:
            return get_bitfield(1, phase, gs) ? 7 : 4;
        default:
            return 3;
        } /* end switch */
    case 3:
        return 1;
    case 4:
        return 16;
    case 5:
        return 14;
    case 6:
        return 13;
    default:
        return 12;
    }
} /* get_huffman_operand_251_9 */
#endif

static FS_LONG get_huffman_opcode_252(FS_LONG *phase, fnt_LocalGraphicStateType *gs)
{
    switch (get_bitfield(2, phase, gs))
    {
    case 0:
        if (get_bitfield(1, phase, gs) == 0) return 7;
        return get_bitfield(1, phase, gs) ? 5 : 4;
    case 1:
        switch (get_bitfield(2, phase, gs))
        {
        case 0:
            return 8;
        case 1:
            return 9;
        case 2:
            return 0;
        default:
            if (get_bitfield(1, phase, gs)) return 3;
            return get_bitfield(1, phase, gs) ? 15 : 6;
        }   /* end switch */
    case 2:
        return 1;
    default:
        return 2;
    }   /* end switch */
}  /* end get_huffman_opcode_252 */

static FS_LONG get_huffman_operand_252_0(FS_LONG *phase, fnt_LocalGraphicStateType *gs)
{
    if (get_bitfield(1, phase, gs) == 0) return 1;
    switch (get_bitfield(2, phase, gs))
    {
    case 0:
        return 3;
    case 1:
        if (get_bitfield(1, phase, gs) == 1) return 5;
        switch (get_bitfield(2, phase, gs))
        {
        case 0:
            return 10;
        case 1:
            switch (get_bitfield(2, phase, gs))
            {
            case 0:
                switch (get_bitfield(3, phase, gs))
                {
                case 0:
                    return 48;
                case 1:
                    return 64;
                case 2:
                    return 80;
                case 3:
                    return 96;
                case 4:
                    return 112;
                case 5:
                    return 128;
                case 6:
                    return 144;
                default:
                    return 160;
                }
            case 1:
                switch (get_bitfield(3, phase, gs))
                {
                case 0:
                    return 176;
                case 1:
                    return 192;
                case 2:
                    return 208;
                case 3:
                    return 224;
                case 4:
                    return 240;
                case 5:
                    return 256;
                case 6:
                    return get_bitfield(1, phase, gs) ? 15 : 13;
                default:
                    return get_bitfield(1, phase, gs) ? 32 : 16;
                }
            case 2:
                return 12;
            default:
                return get_bitfield(1, phase, gs) ? 14 : 11;
            } /* end switch */
        case 2:
            return 7;
        default:
            return 9;
        } /* end switch */
    case 2:
        return 2;
    default:
        if (get_bitfield(1, phase, gs) == 1) return 4;
        return get_bitfield(1, phase, gs) ? 8 : 6;
    } /* end switch */
} /* get_huffman_operand_252_0 */

static FS_LONG get_huffman_operand_252_1(FS_LONG *phase, fnt_LocalGraphicStateType *gs)
{
    switch (get_bitfield(2, phase, gs))
    {
    case 0:
        return 1;
    case 1:
        if (get_bitfield(1, phase, gs) == 1) return 7;
        if (get_bitfield(1, phase, gs) == 0) return 9;
        return get_bitfield(1, phase, gs) ? 6 : 11;
    case 2:
        if (get_bitfield(1, phase, gs) == 0) return 2;
        if (get_bitfield(1, phase, gs) == 0) return 4;
        if (get_bitfield(1, phase, gs) == 1) return 10;
        return get_bitfield(1, phase, gs) ? 13 : 14;
    default:
        switch (get_bitfield(2, phase, gs))
        {
        case 0:
            return 16;
        case 1:
            return 8;
        case 2:
            return 3;
        default:
            if (get_bitfield(1, phase, gs) == 1) return 5;
            if (get_bitfield(1, phase, gs) == 0) return 12;
            if (get_bitfield(1, phase, gs) == 0) return 15;
            if (get_bitfield(1, phase, gs) == 1) return 32;
            switch (get_bitfield(3, phase, gs))
            {
            case 0:
                return 240;
            case 1:
                return 256;
            case 2:
                return get_bitfield(1, phase, gs) ? 64 : 48;
            case 3:
                return get_bitfield(1, phase, gs) ? 96 : 80;
            case 4:
                return get_bitfield(1, phase, gs) ? 128 : 112;
            case 5:
                return get_bitfield(1, phase, gs) ? 160 : 144;
            case 6:
                return get_bitfield(1, phase, gs) ? 192 : 176;
            default:
                return get_bitfield(1, phase, gs) ? 224 : 208;
            }
        } /* end switch */
    } /* end switch */
} /* get_huffman_operand_252_1 */

static FS_LONG get_huffman_operand_252_2(FS_LONG *phase, fnt_LocalGraphicStateType *gs)
{
    switch (get_bitfield(3, phase, gs))
    {
    case 0:
        if (get_bitfield(1, phase, gs) == 0) return 6;
        if (get_bitfield(1, phase, gs) == 1) return 12;
        if (get_bitfield(1, phase, gs) == 1) return 80;
        if (get_bitfield(1, phase, gs) == 1) return 96;
        if (get_bitfield(1, phase, gs) == 1) return 112;
        switch (get_bitfield(3, phase, gs))
        {
        case 0:
            return 160;
        case 1:
            return 176;
        case 2:
            return 192;
        case 3:
            return 208;
        case 4:
            return 224;
        case 5:
            return 240;
        case 6:
            return 256;
        default:
            return get_bitfield(1, phase, gs) ? 144 : 128;
        }
    case 1:
        if (get_bitfield(1, phase, gs) == 0) return 5;
        return get_bitfield(1, phase, gs) ? 10 : 14;
    case 2:
        return 16;
    case 3:
        return 1;
    case 4:
        if (get_bitfield(1, phase, gs) == 0) return 48;
        return get_bitfield(1, phase, gs) ? 64 : 9;
    case 5:
        if (get_bitfield(1, phase, gs) == 0) return 4;
        return get_bitfield(1, phase, gs) ? 7 : 11;
    case 6:
        if (get_bitfield(1, phase, gs) == 1) return 3;
        if (get_bitfield(1, phase, gs) == 0) return 8;
        return get_bitfield(1, phase, gs) ? 15 : 13;
    default:
        return get_bitfield(1, phase, gs) ? 2 : 32;
    }
} /* get_huffman_operand_252_2 */

static FS_LONG get_huffman_operand_252_3(FS_LONG *phase, fnt_LocalGraphicStateType *gs)
{
    if (get_bitfield(1, phase, gs) == 1) return 1;
    if (get_bitfield(1, phase, gs) == 1) return 2;
    if (get_bitfield(1, phase, gs) == 1) return 3;
    if (get_bitfield(1, phase, gs) == 0) return 4;
    switch (get_bitfield(2, phase, gs))
    {
    case 0:
        switch (get_bitfield(2, phase, gs))
        {
        case 0:
            return 16;
        case 1:
            return get_bitfield(1, phase, gs) ? 11 : 8;
        case 2:
            return 9;
        default:
            return get_bitfield(1, phase, gs) ? 13 : 12;
        } /* end switch */
    case 1:
        return 7;
    case 2:
        return 6;
    default:
        if (get_bitfield(1, phase, gs) == 1) return 5;
        if (get_bitfield(1, phase, gs) == 1) return 10;
        return get_bitfield(1, phase, gs) ? 15 : 14;
    } /* end switch */
} /* get_huffman_operand_252_3 */

static FS_LONG get_huffman_operand_252_4(FS_LONG *phase, fnt_LocalGraphicStateType *gs)
{
    if (get_bitfield(1, phase, gs) == 1) return 1;
    if (get_bitfield(1, phase, gs) == 1) return 2;
    if (get_bitfield(1, phase, gs) == 1) return 3;
    if (get_bitfield(1, phase, gs) == 0) return 4;
    switch (get_bitfield(2, phase, gs))
    {
    case 0:
        if (get_bitfield(1, phase, gs) == 0) return 7;
        if (get_bitfield(1, phase, gs) == 0) return 9;
        return get_bitfield(1, phase, gs) ? 12 : 11;
    case 1:
        switch (get_bitfield(2, phase, gs))
        {
        case 0:
            return get_bitfield(1, phase, gs) ? 14 : 13;
        case 1:
            return get_bitfield(1, phase, gs) ? 16 : 15;
        case 2:
            return 8;
        default:
            return 10;
        } /* end switch */
    case 2:
        return 6;
    default:
        return 5;
    } /* end switch */
} /* get_huffman_operand_252_4 */

static FS_LONG get_huffman_operand_252_5(FS_LONG *phase, fnt_LocalGraphicStateType *gs)
{
    switch (get_bitfield(2, phase, gs))
    {
    case 0:
        return 4;
    case 1:
        if (get_bitfield(1, phase, gs) == 0) return 5;
        if (get_bitfield(1, phase, gs) == 1) return 6;
        if (get_bitfield(1, phase, gs) == 1) return 7;
        if (get_bitfield(1, phase, gs) == 0) return 9;
        if (get_bitfield(1, phase, gs) == 1) return 8;
        if (get_bitfield(1, phase, gs) == 1) return 10;
        switch (get_bitfield(2, phase, gs))
        {
        case 0:
            return get_bitfield(1, phase, gs) ? 12 : 1;
        case 1:
            return 11;
        case 2:
            return get_bitfield(1, phase, gs) ? 14 : 13;
        default:
            return get_bitfield(1, phase, gs) ? 16 : 15;
        } /* end switch */
    case 2:
        return 3;
    default:
        return 2;
    } /* end switch */
} /* get_huffman_operand_252_5 */

static FS_LONG get_huffman_operand_252_6(FS_LONG *phase, fnt_LocalGraphicStateType *gs)
{
    if (get_bitfield(1, phase, gs) == 1) return 2;
    if (get_bitfield(1, phase, gs) == 1) return 3;
    if (get_bitfield(1, phase, gs) == 1) return 4;
    switch (get_bitfield(2, phase, gs))
    {
    case 0:
        if (get_bitfield(1, phase, gs) == 0) return 8;
        if (get_bitfield(1, phase, gs) == 1) return 7;
        return get_bitfield(1, phase, gs) ? 9 : 1;
    case 1:
        return 6;
    case 2:
        switch (get_bitfield(2, phase, gs))
        {
        case 0:
            return get_bitfield(1, phase, gs) ? 12 : 10;
        case 1:
            return 11;
        case 2:
            return get_bitfield(1, phase, gs) ? 14 : 13;
        default:
            return get_bitfield(1, phase, gs) ? 16 : 15;
        } /* end switch */
    default:
        return 5;
    } /* end switch */
} /* get_huffman_operand_252_6 */

static FS_LONG get_huffman_operand_252_8(FS_LONG *phase, fnt_LocalGraphicStateType *gs)
{
    if (get_bitfield(1, phase, gs) == 1) return 1;
    if (get_bitfield(1, phase, gs) == 1) return 2;
    if (get_bitfield(1, phase, gs) == 1) return 3;
    switch (get_bitfield(2, phase, gs))
    {
    case 0:
        switch (get_bitfield(2, phase, gs))
        {
        case 0:
            return 8;
        case 1:
            return 9;
        case 2:
            return 10;
        default:
            return 11;
        } /* end switch */
    case 1:
        switch (get_bitfield(2, phase, gs))
        {
        case 0:
            return 12;
        case 1:
            return 13;
        case 2:
            return 14;
        default:
            return 15;
        } /* end switch */
    case 2:
        if (get_bitfield(1, phase, gs) == 0) return 5;
        if (get_bitfield(1, phase, gs) == 0) return 16;
        return get_bitfield(1, phase, gs) ? 7 : 6;
    default:
        return 4;
    } /* end switch */
} /* get_huffman_operand_252_8 */

static FS_LONG get_huffman_operand_252_9(FS_LONG *phase, fnt_LocalGraphicStateType *gs)
{
    if (get_bitfield(1, phase, gs) == 1) return 2;
    switch (get_bitfield(2, phase, gs))
    {
    case 0:
        if (get_bitfield(1, phase, gs) == 0) return 7;
        switch (get_bitfield(2, phase, gs))
        {
        case 0:
            return 9;
        case 1:
            return get_bitfield(1, phase, gs) ? 11 : 16;
        case 2:
            if (get_bitfield(1, phase, gs) == 0) return 10;
            if (get_bitfield(1, phase, gs) == 0) return 12;
            if (get_bitfield(1, phase, gs) == 0) return 14;
            if (get_bitfield(1, phase, gs) == 0) return 15;
            return get_bitfield(1, phase, gs) ? 13 : 1;
        default:
            return 8;
        } /* end switch */
    case 1:
        return get_bitfield(1, phase, gs) ? 6 : 5;
    case 2:
        return 3;
    default:
        return 4;
    } /* end switch */
} /* get_huffman_operand_252_9 */

/* The following function looks at a variable number of bits to determine the next Huffman-
    encoded opcode in the AA 253 case. The values it expects are as defined
    in the following Python dictionary (which is exactly copied from deltacompressor.py):
    o = {
        0: '110',
        1: '111',
        2: '0011',
        3: '000',
        4: '01',
        5: '10',
        6: '00101',
        7: '00100'}
 */
static FS_LONG get_huffman_opcode_3(FS_LONG *phase, fnt_LocalGraphicStateType *gs)
{
    FS_LONG retVal;

    switch (get_bitfield(2, phase, gs))
    {
    case 0:
        /* we know it's 00... */
        if (get_bitfield(1, phase, gs) == 0)
            retVal = 3;

        /* we know it's 001... */
        else if (get_bitfield(1, phase, gs) == 1)
            retVal = 2;

        /* we know it's 0010... */
        else if (get_bitfield(1, phase, gs) == 0)
            retVal = 7;
        /* we know it's 00101 */
        else
            retVal = 6;

        break;
    case 1:
        retVal = 4;
        break;

    case 2:
        retVal = 5;
        break;
    default:
        /* we know it's 11... */
        if (get_bitfield(1, phase, gs) == 1)
            retVal = 1;

        /* we know it's 110 */
        else
            retVal = 0;

        break;
    }   /* end switch */
    return retVal;
}   /* get_huffman_opcode_3 */
/* The following function looks at a variable number of bits to determine the next Huffman-
    encoded operand in the AA 253, opcode 4 case. The values it expects are as defined
    in the following Python dictionary (which is exactly copied from deltacompressor.py):

    o4 = {
        0: '10',
        1: '111',
        2: '011',
        3: '010',
        4: '001',
        5: '000',
        6: '1101',
        7: '1100'}
 */
static FS_LONG get_huffman_operand_4(FS_LONG *phase, fnt_LocalGraphicStateType *gs)
{
    FS_LONG retVal;

    switch (get_bitfield(2, phase, gs))
    {
    case 0:
        /* we know it's 00... */
        if (get_bitfield(1, phase, gs) == 0)
            retVal = 5;

        /* we know it's 001 */
        else
            retVal = 4;

        break;
    case 1:
        /* we know it's 01... */
        if (get_bitfield(1, phase, gs) == 0)
            retVal = 3;

        /* we know it's 011 */
        else
            retVal = 2;

        break;

    case 2:
        retVal = 0;
        break;
    default:
        /* we know it's 11... */
        if (get_bitfield(1, phase, gs) == 1)
            retVal = 1;

        /* we know it's 110... */
        else if (get_bitfield(1, phase, gs) == 0)
            retVal = 7;

        /* we know it's 1101 */
        else
            retVal = 6;

        break;
    }   /* end switch */
    return retVal;
}   /* get_huffman_operand_4 */
/* The following function looks at a variable number of bits to determine the next Huffman-
    encoded operand in the AA 253, opcode 6 case. The values it expects are as defined
    in the following Python dictionary (which is exactly copied from deltacompressor.py):

    o6 = {
        0: '11',
        1: '00',
        2: '011',
        3: '1001',
        4: '1000',
        5: '0101',
        6: '0100',
        7: '101'}
 */
static FS_LONG get_huffman_operand_6(FS_LONG *phase, fnt_LocalGraphicStateType *gs)
{
    FS_LONG retVal;

    switch (get_bitfield(2, phase, gs))
    {
    case 0:
        retVal = 1;
        break;

    case 1:
        /* we know it's 01... */
        if (get_bitfield(1, phase, gs) == 1)
            retVal = 2;
        /* we know it's 010... */
        else if (get_bitfield(1, phase, gs) == 0)
            retVal = 6;

        /* we know it's 0101 */
        else
            retVal = 5;

        break;
    case 2:
        /* we know it's 10... */
        if (get_bitfield(1, phase, gs) == 1)
            retVal = 7;

        /* we know it's 100... */
        else if (get_bitfield(1, phase, gs) == 0)
            retVal = 4;

        /* we know it's 1001 */
        else
            retVal = 3;

        break;

    default:
        retVal = 0;
        break;
    }   /* end switch */

    return retVal;
}   /* get_huffman_operand_6 */

#ifdef FS_EDGE_HINTS
static FS_VOID do_deltas_250_deltapart(fnt_LocalGraphicStateType *gs, FS_LONG *phase)
{
    F26DOT6     currDelta, deltaDelta;
    FS_LONG     pow2 = get_bitfield(4, phase, gs);
    FS_LONG     currPPEM, currPtBase, lowestDelta, needsAA9;
    FS_USHORT   renderingPPEM;

    if (pow2 == 8)  /* really -8 */
    {
        if (get_bitfield(1, phase, gs))
            ADFMAZKeepInBox(gs);

        /* There is no other data in this case, so return immediately */
        return;
    }

    deltaDelta = 1 << (pow2 > 9 ? pow2 - 10 : pow2 + 6);

    if (get_bitfield(1, phase, gs))
        lowestDelta = (get_bitfield(16, phase, gs) << 16) >> 16;
    else
        lowestDelta = (get_bitfield(8, phase, gs) << 24) >> 24;

    currDelta = lowestDelta * deltaDelta;
    needsAA9 = get_bitfield(1, phase, gs);
    renderingPPEM = gs->globalGS->pixelsPerEm;
    currPPEM = 5;
    currPtBase = 0;

    if (!gs->globalGS->identityTransformation)
        renderingPPEM = (FS_USHORT) FixMul(renderingPPEM, fnt_GetCVTScale(gs));

    for ( ; ; )  /* while (1) */
    {
        switch (get_huffman_opcode_252(phase, gs))
        {
        case 0:  /* advance delta (skipping zero), reset currPPEM and currPtBase */
        {
            FS_LONG     count = get_huffman_operand_252_0(phase, gs);
            F26DOT6     priorDelta = currDelta;

            currDelta += count * deltaDelta;

            if (priorDelta < 0 && currDelta >= 0)
                currDelta += deltaDelta;

            currPPEM = 5;
            currPtBase = 0;
            break;
        }  /* end case */

        case 1:  /* advance currPPEM, reset currPtBase */
        {
            FS_LONG     count = get_huffman_operand_252_1(phase, gs);

            currPPEM += count;
            currPtBase = 0;
            break;
        }  /* end case */

        case 2:  /* Advance currPtBase */
        {
            FS_LONG     count = get_huffman_operand_252_2(phase, gs);

            currPtBase += count;
            break;
        }  /* end case */

        case 3:  /* Type 1 move (whole glyph) */
        {
            FS_LONG     count = get_huffman_operand_252_3(phase, gs);
            FS_LONG     ppemDiff = renderingPPEM - currPPEM;

            if (ppemDiff >= 0 && ppemDiff < count)
            {
                gs->loop = count = gs->elements[1].ep[gs->elements[1].nc - 1];

                while (count >= 0)
                    CHECK_PUSH(gs, gs->stackPointer, count--);

                CHECK_PUSH(gs, gs->stackPointer, currDelta);
                fnt_SHPIX(gs);
            }  /* end if */

            break;
        }  /* end case */

        case 4:  /* Type 2 move (contour, deep) */
        {
            FS_LONG     count = get_huffman_operand_252_4(phase, gs);
            FS_LONG     ppemDiff = renderingPPEM - currPPEM;

            if (ppemDiff >= 0 && ppemDiff < count)
            {
                FS_LONG     firstContourPt = gs->elements[1].sp[currPtBase];
                FS_LONG     lastContourPt = gs->elements[1].ep[currPtBase];
                FS_LONG     p;

                for (p = firstContourPt; p <= lastContourPt; p += 1)
                    CHECK_PUSH(gs, gs->stackPointer, p);

                CHECK_PUSH(gs, gs->stackPointer, currDelta);
                gs->loop = lastContourPt - firstContourPt;
                fnt_SHPIX(gs);
            }  /* end if */

            break;
        }  /* end case */

        case 5:  /* Type 2 move (contour, wide) */
        {
            FS_LONG     count = get_huffman_operand_252_5(phase, gs);

            if (renderingPPEM == currPPEM)
            {
                FS_LONG     firstContourPt = gs->elements[1].sp[currPtBase];
                FS_LONG     lastContourPt = gs->elements[1].ep[currPtBase + count - 1];
                FS_LONG     p;

                for (p = firstContourPt; p <= lastContourPt; p += 1)
                    CHECK_PUSH(gs, gs->stackPointer, p);

                CHECK_PUSH(gs, gs->stackPointer, currDelta);
                gs->loop = lastContourPt - firstContourPt;
                fnt_SHPIX(gs);
            }  /* end if */

            break;
        }  /* end case */

        case 6:  /* Type 3 move (pegged, deep), advances currPtBase by 1 */
        {
            FS_LONG     ppemCount = get_huffman_operand_252_6(phase, gs);
            FS_LONG     ppemDiff = renderingPPEM - currPPEM;

            if (ppemDiff >= 0 && ppemDiff < ppemCount)
            {
                FS_LONG     lastContourPt = gs->elements[1].ep[gs->elements[1].nc - 1];
                F26DOT6     *oxy = (gs->proj.x ? gs->elements[1].ox : gs->elements[1].oy);
                F26DOT6     peg = oxy[currPtBase];
                FS_LONG     count = 0;
                FS_LONG     p;
                FS_BYTE     *oc = gs->elements[1].onCurve;

                for (p = 0; p <= lastContourPt; p += 1)
                {
                    if (oc[p] && (oxy[p] == peg))
                    {
                        CHECK_PUSH(gs, gs->stackPointer, p);
                        count += 1;
                    }  /* end if */
                }  /* end for */

                CHECK_PUSH(gs, gs->stackPointer, currDelta);
                gs->loop = count - 1;
                fnt_SHPIX(gs);
            }  /* end if */

            currPtBase += 1;
            break;
        }  /* end case */

        case 7:  /* Type 3 move (pegged, no argument), advances currPtBase by 1 */
        {
            if (renderingPPEM == currPPEM)
            {
                FS_LONG     lastContourPt = gs->elements[1].ep[gs->elements[1].nc - 1];
                F26DOT6     *oxy = (gs->proj.x ? gs->elements[1].ox : gs->elements[1].oy);
                F26DOT6     peg = oxy[currPtBase];
                FS_LONG     count = 0;
                FS_LONG     p;
                FS_BYTE     *oc = gs->elements[1].onCurve;

                for (p = 0; p <= lastContourPt; p += 1)
                {
                    if (oc[p] && (oxy[p] == peg))
                    {
                        CHECK_PUSH(gs, gs->stackPointer, p);
                        count += 1;
                    }  /* end if */
                }  /* end for */

                CHECK_PUSH(gs, gs->stackPointer, currDelta);
                gs->loop = count - 1;
                fnt_SHPIX(gs);
            }  /* end if */

            currPtBase += 1;
            break;
        }  /* end case */

        case 8:  /* Type 4 move (singles, deep), advances currPtBase by 1 */
        {
            FS_LONG     count = get_huffman_operand_252_8(phase, gs);
            FS_LONG     ppemDiff = renderingPPEM - currPPEM;

            if (ppemDiff >= 0 && ppemDiff < count)
            {
                CHECK_PUSH(gs, gs->stackPointer, currPtBase);
                CHECK_PUSH(gs, gs->stackPointer, currDelta);
                fnt_SHPIX(gs);
            }  /* end if */

            currPtBase += 1;
            break;
        }  /* end case */

        case 9:  /* Type 4 move (singles, wide), advances currPtBase by 1 */
        {
            FS_LONG     count = get_huffman_operand_252_9(phase, gs);
            FS_LONG     p;

            if (renderingPPEM == currPPEM)
            {
                for (p = currPtBase; p < (currPtBase + count); p += 1)
                    CHECK_PUSH(gs, gs->stackPointer, p);

                CHECK_PUSH(gs, gs->stackPointer, currDelta);
                gs->loop = count - 1;
                fnt_SHPIX(gs);
            }

            currPtBase += 1;
            break;
        }  /* end case */

        default:  /* end of hints */
        {
            if (needsAA9)
                ADFMAZKeepInBox(gs);

            return;
        }  /* end case */
        }  /* end switch */
    }  /* end while */
}  /* do_deltas_250_deltapart */

static FS_VOID do_deltas_250_mazpart(fnt_LocalGraphicStateType *gs, FS_LONG *phase)
{
    F26DOT6     baseDelta, currDelta, deltaDelta;
    FS_LONG     granulatedBaseDelta = (get_bitfield(8, phase, gs) << 24) >> 24;
    FS_LONG     basePoint, basePPEM, currMode, currPoint, currPPEM, inY, pow2;
    FS_USHORT   renderingPPEM;
    MAZ_DATA    *md;

    if (!granulatedBaseDelta)
    {
        CHECK_PUSH(gs, gs->stackPointer, (get_bitfield(1, phase, gs) ? 6 : 5));
        fnt_AA(gs);
        return;  /* nothing more to do here */
    }

    pow2 = get_bitfield(4, phase, gs);
    deltaDelta = 1 << (pow2 > 9 ? pow2 - 10 : pow2 + 6);
    currDelta = baseDelta = granulatedBaseDelta * deltaDelta;
    currPPEM = basePPEM = get_bitfield(6, phase, gs);
    currPoint = basePoint = get_bitfield(8, phase, gs);
    renderingPPEM = gs->globalGS->pixelsPerEm;
    currMode = inY = 0;
    md = &gs->globalGS->maz_data;

    fnt_SVTCA_1(gs);

    if (!gs->globalGS->identityTransformation)
        renderingPPEM = (FS_USHORT) FixMul(gs->globalGS->pixelsPerEm, fnt_GetCVTScale(gs));

    for ( ; ; )  /* while (1) */
    {
        switch (get_huffman_opcode_251(phase, gs))
        {
        case 0:  /* advance currPoint, reset currDelta and currPPEM */
        {
            FS_LONG     count = get_huffman_operand_251_0(phase, gs);

            currPoint += count;
            currDelta = baseDelta;
            currPPEM = basePPEM;
            break;
        }  /* end case 0 */

        case 1:  /* advance currDelta (skipping zero), reset currPPEM */
        {
            FS_LONG     count = get_huffman_operand_251_1(phase, gs);
            F26DOT6     priorDelta = currDelta;

            currDelta += count * deltaDelta;

            if (priorDelta < 0 && currDelta >= 0)
                currDelta += deltaDelta;

            currPPEM = basePPEM;
            break;
        }  /* end case 1 */

        case 2:  /* advance currPPEM, band 1 */
        {
            FS_LONG     count = get_huffman_operand_251_2(phase, gs);

            currPPEM += count;
            break;
        }  /* end case 2 */

        case 3:  /* advance currPPEM, band 2 */
        {
            FS_LONG     count = get_huffman_operand_251_3(phase, gs);

            currPPEM += (count + 16);
            break;
        }  /* end case 3 */

        case 4:  /* apply MAZDELTA (single), add 2 to currPPEM */
            if (currPPEM == renderingPPEM)
            {
                if (inY)
                {
                    md->Ydeltashift[md->numYdeltas] = currDelta;
                    md->Ydeltapoint[md->numYdeltas] = currPoint;
                    md->numYdeltas += 1;
                }
                else
                {
                    md->Xdeltashift[md->numXdeltas] = currDelta;
                    md->Xdeltapoint[md->numXdeltas] = currPoint;
                    md->numXdeltas += 1;
                }
            }

            currPPEM += 2;
            break;  /* end case 4 */

        case 5:  /* apply MAZDELTA (range), adjust currPPEM */
        {
            FS_LONG     count = get_huffman_operand_251_5(phase, gs);
            FS_LONG     limit = count + currPPEM;

            if ((renderingPPEM >= currPPEM) && (renderingPPEM < limit))
            {
                if (inY)
                {
                    md->Ydeltashift[md->numYdeltas] = currDelta;
                    md->Ydeltapoint[md->numYdeltas] = currPoint;
                    md->numYdeltas += 1;
                }
                else
                {
                    md->Xdeltashift[md->numXdeltas] = currDelta;
                    md->Xdeltapoint[md->numXdeltas] = currPoint;
                    md->numXdeltas += 1;
                }
            }

            currPPEM += count + (FS_LONG)(count < 17);
            break;
        }  /* end case 5 */

        case 6:  /* reset for MODE/STROKE processing */
            currPoint = basePoint;
            currDelta = baseDelta;
            currPPEM = basePPEM;
            break;  /* end case 6 */

        case 7:  /* set current mode */
            currMode = get_huffman_operand_251_7(phase, gs) & MAZMODEMASK;
            currPPEM = basePPEM;
            break;  /* end case 7 */

        case 8:  /* apply MAZMODE (range), adjust currPPEM */
        {
            FS_LONG     count = get_huffman_operand_251_8(phase, gs);
            FS_LONG     limit = count + currPPEM;

            if ((renderingPPEM >= currPPEM) && (renderingPPEM < limit) && currMode)
            {
                if (inY)
                    md->MAZmethodHorz = currMode;
                else
                    md->MAZmethodVert = currMode;
            }

            currPPEM += count + (FS_LONG)(count < 16);
            break;
        }  /* end case 8 */

        case 9:  /* apply MAZSTROKE (range), adjust currPPEM */
        {
            FS_LONG     count = get_huffman_operand_251_9(phase, gs);
            FS_LONG     limit = count + currPPEM;

            if ((renderingPPEM >= currPPEM) && (renderingPPEM < limit))
            {
                if (inY)
                    md->Hcollapse[md->numHhints++] = currPoint;
                else
                    md->Vcollapse[md->numVhints++] = currPoint;
            }

            currPPEM += count + (FS_LONG)(count < 16);
            break;
        }  /* end case 9 */

        case 10:  /* switch to Y */
            fnt_SVTCA_0(gs);

            if (!gs->globalGS->identityTransformation)
                renderingPPEM = (FS_USHORT) FixMul(gs->globalGS->pixelsPerEm, fnt_GetCVTScale(gs));

            inY = 1;
            currPoint = basePoint;
            currDelta = baseDelta;
            currPPEM = basePPEM;
            break;  /* end case 10 */

        case 11:  /* AA 5 and we're done */
            CHECK_PUSH(gs, gs->stackPointer, 5);
            fnt_AA(gs);
            return;  /* end case 11 and loop */

        case 12:  /* AA 6 and we're done */
            CHECK_PUSH(gs, gs->stackPointer, 6);
            fnt_AA(gs);
            return;  /* end case 12 and loop */

        default:  /* unknown opcode, so just return */
            return;
        }  /* end switch */
    }  /* end while */
}  /* do_deltas_250_mazpart */

static FS_VOID do_deltas_250(fnt_LocalGraphicStateType *gs)
{
    FS_LONG phase = 0;

    do_deltas_250_mazpart(gs, &phase);
    fnt_SVTCA_1(gs);  /* set vectors to x-axis */
    do_deltas_250_deltapart(gs, &phase);
    fnt_SVTCA_0(gs);  /* set vectors to y-axis */
    do_deltas_250_deltapart(gs, &phase);
    fnt_CLEAR(gs);
}  /* do_deltas_250 */

static FS_VOID do_deltas_251(fnt_LocalGraphicStateType *gs)
{
    FS_LONG     phase = 0;
    FS_LONG     granulatedBaseDelta = (get_bitfield(8, &phase, gs) << 24) >> 24;
    FS_LONG     pow2 = get_bitfield(4, &phase, gs);
    F26DOT6     deltaDelta = 1 << (pow2 > 9 ? pow2 - 10 : pow2 + 6);
    F26DOT6     baseDelta = granulatedBaseDelta * deltaDelta;
    FS_LONG     basePPEM = get_bitfield(6, &phase, gs);
    FS_LONG     basePoint = get_bitfield(8, &phase, gs);
    FS_LONG     stillGoing = 1;
    FS_USHORT   renderingPPEM = gs->globalGS->pixelsPerEm;
    F26DOT6     currDelta = baseDelta;
    FS_LONG     currPPEM = basePPEM;
    FS_LONG     currPoint = basePoint;
    FS_LONG     inY = 0;
    MAZ_DATA    *md = &gs->globalGS->maz_data;
    FS_LONG     currMode = 0;

    fnt_SVTCA_1(gs);  /* AA 251 handles axis values itself, rather than relying on hints */
    if (!gs->globalGS->identityTransformation)
        renderingPPEM = (FS_USHORT) FixMul(gs->globalGS->pixelsPerEm, fnt_GetCVTScale(gs));

    while (stillGoing)
    {
        switch (get_huffman_opcode_251(&phase, gs))
        {
        case 0: /* advance currPoint, reset currDelta and currPPEM */
        {
            FS_LONG     count = get_huffman_operand_251_0(&phase, gs);

            currPoint += count;
            currDelta = baseDelta;
            currPPEM = basePPEM;
            break;
        } /* end case 0 */

        case 1: /* advance currDelta (skipping zero), reset currPPEM */
        {
            FS_LONG     count = get_huffman_operand_251_1(&phase, gs);
            F26DOT6     priorDelta = currDelta;

            currDelta += count * deltaDelta;

            if (priorDelta < 0 && currDelta >= 0)
                currDelta += deltaDelta;

            currPPEM = basePPEM;
            break;
        } /* end case 1 */

        case 2: /* advance currPPEM, band 1 */
        {
            FS_LONG     count = get_huffman_operand_251_2(&phase, gs);

            currPPEM += count;
            break;
        } /* end case 2 */

        case 3: /* advance currPPEM, band 2 */
        {
            FS_LONG     count = get_huffman_operand_251_3(&phase, gs);

            currPPEM += (count + 16);
            break;
        } /* end case 3 */

        case 4: /* apply MAZDELTA (single), add 2 to currPPEM */
            if (currPPEM == renderingPPEM)
            {
                if (inY)
                {
                    md->Ydeltashift[md->numYdeltas] = currDelta;
                    md->Ydeltapoint[md->numYdeltas] = currPoint;
                    md->numYdeltas += 1;
                }
                else
                {
                    md->Xdeltashift[md->numXdeltas] = currDelta;
                    md->Xdeltapoint[md->numXdeltas] = currPoint;
                    md->numXdeltas += 1;
                }
            }

            currPPEM += 2;
            break; /* end case 4 */

        case 5: /* apply MAZDELTA (range), adjust currPPEM */
        {
            FS_LONG     count = get_huffman_operand_251_5(&phase, gs);
            FS_LONG     limit = count + currPPEM;

            if ((renderingPPEM >= currPPEM) && (renderingPPEM < limit))
            {
                if (inY)
                {
                    md->Ydeltashift[md->numYdeltas] = currDelta;
                    md->Ydeltapoint[md->numYdeltas] = currPoint;
                    md->numYdeltas += 1;
                }
                else
                {
                    md->Xdeltashift[md->numXdeltas] = currDelta;
                    md->Xdeltapoint[md->numXdeltas] = currPoint;
                    md->numXdeltas += 1;
                }
            }

            currPPEM += count + (FS_LONG)(count < 17);
            break;
        } /* end case 5 */

        case 6: /* reset for MODE/STROKE processing */
            currPoint = basePoint;
            currDelta = baseDelta;
            currPPEM = basePPEM;
            break; /* end case 6 */

        case 7: /* set current mode */
            currMode = get_huffman_operand_251_7(&phase, gs) & MAZMODEMASK;
            currPPEM = basePPEM;
            break; /* end case 7 */

        case 8: /* apply MAZMODE (range), adjust currPPEM */
        {
            FS_LONG     count = get_huffman_operand_251_8(&phase, gs);
            FS_LONG     limit = count + currPPEM;

            if ((renderingPPEM >= currPPEM) && (renderingPPEM < limit) && currMode)
            {
                if (inY)
                    md->MAZmethodHorz = currMode;
                else
                    md->MAZmethodVert = currMode;
            }

            currPPEM += count + (FS_LONG)(count < 16);
            break;
        } /* end case 8 */

        case 9: /* apply MAZSTROKE (range), adjust currPPEM */
        {
            FS_LONG     count = get_huffman_operand_251_9(&phase, gs);
            FS_LONG     limit = count + currPPEM;

            if ((renderingPPEM >= currPPEM) && (renderingPPEM < limit))
            {
                if (inY)
                    md->Hcollapse[md->numHhints++] = currPoint;
                else
                    md->Vcollapse[md->numVhints++] = currPoint;
            }

            currPPEM += count + (FS_LONG)(count < 16);
            break;
        } /* end case 9 */

        case 10: /* switch to Y */
            fnt_SVTCA_0(gs);
            if (!gs->globalGS->identityTransformation)
                renderingPPEM = (FS_USHORT) FixMul(gs->globalGS->pixelsPerEm, fnt_GetCVTScale(gs));
            inY = 1;
            currPoint = basePoint;
            currDelta = baseDelta;
            currPPEM = basePPEM;
            break; /* end case 10 */

        case 11: /* AA 5 and we're done */
            if (phase)
                (void) CHECK_POP(gs, gs->stackPointer);  /* get rid of leftovers */

            CHECK_PUSH(gs, gs->stackPointer, 5);
            stillGoing = 0;
            fnt_AA(gs);
            break; /* end case 11 */

        case 12: /* AA 6 and we're done */
            if (phase)
                (void) CHECK_POP(gs, gs->stackPointer);  /* get rid of leftovers */

            CHECK_PUSH(gs, gs->stackPointer, 6);
            stillGoing = 0;
            fnt_AA(gs);
            break; /* end case 11 */

        default:
            /* unknown opcode, so clear the stack and finish */
            fnt_CLEAR(gs);
            stillGoing = 0;
            break;
        }
    }
} /* do_deltas_251 */
#endif

static FS_VOID do_deltas_252(fnt_LocalGraphicStateType *gs)
{
    FS_LONG     controlWord = (CHECK_POP(gs, gs->stackPointer)) & 0xFFFFL;
    FS_LONG     pow2 = (controlWord & 0x0F00L) >> 8;
    F26DOT6     deltaDelta = 1 << (pow2 > 9 ? pow2 - 10 : pow2 + 6);
    FS_LONG     unsignedBase = controlWord & 0xFFL;
    F26DOT6     currDelta = ((controlWord & 0x8000L) ? -unsignedBase : unsignedBase) * deltaDelta;
    FS_USHORT   renderingPPEM = gs->globalGS->pixelsPerEm;
    FS_LONG     stillGoing = 1;
    FS_LONG     phase = 0;
    FS_LONG     currPPEM = 5;
    FS_LONG     currPtBase = 0;

    if ((controlWord & 0x8000L) && (unsignedBase == 0))  /* this is an exceedingly rare case */
        currDelta = (CHECK_POP(gs, gs->stackPointer)) * deltaDelta;

    if (!gs->globalGS->identityTransformation)
        renderingPPEM = (FS_USHORT) FixMul(renderingPPEM, fnt_GetCVTScale(gs));

    while (stillGoing)
    {
        switch (get_huffman_opcode_252(&phase, gs))
        {
        case 0: /* advance delta (skipping zero), reset currPPEM and currPtBase */
        {
            FS_LONG     count = get_huffman_operand_252_0(&phase, gs);
            F26DOT6     priorDelta = currDelta;

            currDelta += count * deltaDelta;

            if (priorDelta < 0 && currDelta >= 0)
                currDelta += deltaDelta;

            currPPEM = 5;
            currPtBase = 0;
            break;
        }   /* end case */

        case 1: /* advance currPPEM, reset currPtBase */
        {
            FS_LONG     count = get_huffman_operand_252_1(&phase, gs);

            currPPEM += count;
            currPtBase = 0;
            break;
        }   /* end case */

        case 2: /* Advance currPtBase */
        {
            FS_LONG     count = get_huffman_operand_252_2(&phase, gs);

            currPtBase += count;
            break;
        }   /* end case */

        case 3: /* Type 1 move (whole glyph) */
        {
            FS_LONG     count = get_huffman_operand_252_3(&phase, gs);
            FS_LONG     ppemDiff = renderingPPEM - currPPEM;

            if (ppemDiff >= 0 && ppemDiff < count)
            {
                gs->loop = count = gs->elements[1].ep[gs->elements[1].nc - 1];

                while (count >= 0)
                    CHECK_PUSH(gs, gs->stackPointer, count--);

                CHECK_PUSH(gs, gs->stackPointer, currDelta);
                fnt_SHPIX(gs);
            }   /* end if */

            break;
        }   /* end case */

        case 4: /* Type 2 move (contour, deep), advances currPtBase by 1 */
        {
            FS_LONG     count = get_huffman_operand_252_4(&phase, gs);
            FS_LONG     ppemDiff = renderingPPEM - currPPEM;

            if (ppemDiff >= 0 && ppemDiff < count)
            {
                FS_LONG     firstContourPt = gs->elements[1].sp[currPtBase];
                FS_LONG     lastContourPt = gs->elements[1].ep[currPtBase];
                FS_LONG     p;

                for (p = firstContourPt; p <= lastContourPt; p += 1)
                    CHECK_PUSH(gs, gs->stackPointer, p);

                CHECK_PUSH(gs, gs->stackPointer, currDelta);
                gs->loop = lastContourPt - firstContourPt;
                fnt_SHPIX(gs);
            }   /* end if */

            break;
        }   /* end case */

        case 5: /* Type 2 move (contour, wide), advances currPtBase count or count+1 */
        {
            FS_LONG     count = get_huffman_operand_252_5(&phase, gs);

            if (renderingPPEM == currPPEM)
            {
                FS_LONG     firstContourPt = gs->elements[1].sp[currPtBase];
                FS_LONG     lastContourPt = gs->elements[1].ep[currPtBase + count - 1];
                FS_LONG     p;

                for (p = firstContourPt; p <= lastContourPt; p += 1)
                    CHECK_PUSH(gs, gs->stackPointer, p);

                CHECK_PUSH(gs, gs->stackPointer, currDelta);
                gs->loop = lastContourPt - firstContourPt;
                fnt_SHPIX(gs);
            }   /* end if */

            break;
        }   /* end case */

        case 6: /* Type 3 move (pegged, deep), advances currPtBase by 1 */
        {
            FS_LONG     ppemCount = get_huffman_operand_252_6(&phase, gs);
            FS_LONG     ppemDiff = renderingPPEM - currPPEM;

            if (ppemDiff >= 0 && ppemDiff < ppemCount)
            {
                FS_LONG     lastContourPt = gs->elements[1].ep[gs->elements[1].nc - 1];
                F26DOT6     *oxy = (gs->proj.x ? gs->elements[1].ox : gs->elements[1].oy);
                F26DOT6     peg = oxy[currPtBase];
                FS_LONG     count = 0;
                FS_LONG     p;
                FS_BYTE     *oc = gs->elements[1].onCurve;

                for (p = 0; p <= lastContourPt; p += 1)
                {
                    if (oc[p] && (oxy[p] == peg))
                    {
                        CHECK_PUSH(gs, gs->stackPointer, p);
                        count += 1;
                    }   /* end if */
                }   /* end for */

                CHECK_PUSH(gs, gs->stackPointer, currDelta);
                gs->loop = count - 1;
                fnt_SHPIX(gs);
            }   /* end if */

            currPtBase += 1;
            break;
        }   /* end case */

        case 7: /* Type 3 move (pegged, no argument), advances currPtBase by 1 */
        {
            if (renderingPPEM == currPPEM)
            {
                FS_LONG     lastContourPt = gs->elements[1].ep[gs->elements[1].nc - 1];
                F26DOT6     *oxy = (gs->proj.x ? gs->elements[1].ox : gs->elements[1].oy);
                F26DOT6     peg = oxy[currPtBase];
                FS_LONG     count = 0;
                FS_LONG     p;
                FS_BYTE     *oc = gs->elements[1].onCurve;

                for (p = 0; p <= lastContourPt; p += 1)
                {
                    if (oc[p] && (oxy[p] == peg))
                    {
                        CHECK_PUSH(gs, gs->stackPointer, p);
                        count += 1;
                    }   /* end if */
                }   /* end for */

                CHECK_PUSH(gs, gs->stackPointer, currDelta);
                gs->loop = count - 1;
                fnt_SHPIX(gs);
            }   /* end if */

            currPtBase += 1;
            break;
        }   /* end case */

        case 8: /* Type 4 move (singles, deep), advances currPtBase by 1 */
        {
            FS_LONG     count = get_huffman_operand_252_8(&phase, gs);
            FS_LONG     ppemDiff = renderingPPEM - currPPEM;

            if (ppemDiff >= 0 && ppemDiff < count)
            {
                CHECK_PUSH(gs, gs->stackPointer, currPtBase);
                CHECK_PUSH(gs, gs->stackPointer, currDelta);
                fnt_SHPIX(gs);
            }   /* end if */

            currPtBase += 1;
            break;
        }   /* end case */

        case 9: /* Type 4 move (singles, wide), advances currPtBase count or count+1 */
        {
            FS_LONG     count = get_huffman_operand_252_9(&phase, gs);
            FS_LONG     p;

            if (renderingPPEM == currPPEM)
            {
                for (p = currPtBase; p < (currPtBase + count); p += 1)
                    CHECK_PUSH(gs, gs->stackPointer, p);

                CHECK_PUSH(gs, gs->stackPointer, currDelta);
                gs->loop = count - 1;
                fnt_SHPIX(gs);
            }

            currPtBase += 1;
            break;
        }   /* end case */

        default:    /* end of hints */
        {
            if (phase)
                (void) CHECK_POP(gs, gs->stackPointer);  /* get rid of leftovers */

#ifdef FS_EDGE_HINTS
            if (controlWord & 0x4000L)
            {
                ADFMAZKeepInBox(gs);
            }
#endif

            stillGoing = 0;
            break;
        }   /* end case */
        }   /* end switch */
    }   /* end while */
}  /* end do_deltas_252 */

static FS_VOID do_deltas_253(fnt_LocalGraphicStateType *gs)
{
    F26DOT6        deltaBase = CHECK_POP(gs, gs->stackPointer);
    F26DOT6        deltaDelta = CHECK_POP(gs, gs->stackPointer);
    F26DOT6        ppemAndFlags = CHECK_POP(gs, gs->stackPointer);
    F26DOT6     currPPEM = ppemAndFlags & 0xFF;
    FS_LONG     halfPhase = (ppemAndFlags & 0x1E00L) >> 9;
    F26DOT6        currDelta = deltaBase;
    FS_LONG        count, currPointbase = 0, phase = 0, point, repeat = 1, stillGoing = 1;

    FS_LONG     halfData = (CHECK_POP(gs, gs->stackPointer)) & 0xFFFFL;
    FS_LONG     halfPPEM = halfData >> 10;
    FS_LONG     halfSkipWords = halfData & 0x3FFL;

    FS_USHORT   renderingPPEM = gs->globalGS->pixelsPerEm;

    if ( !gs->globalGS->identityTransformation )
    {
        FS_FIXED scale;

        scale = fnt_GetCVTScale( gs );
        renderingPPEM = (FS_USHORT)FixMul( renderingPPEM, scale );
    }

    if ((halfSkipWords + halfPhase) && (renderingPPEM >= halfPPEM))
    {
        while (halfSkipWords--)
            (void) CHECK_POP(gs, gs->stackPointer);
        phase = halfPhase;
        currPPEM = halfPPEM;
    }
    while (stillGoing)
    {
        switch (get_huffman_opcode_3(&phase, gs))
        {
        case 0:
            /* opcode 0: advance to next PPEM, resetting everything else */
            currPPEM += repeat;

            if (currPPEM > renderingPPEM)
            {
                stillGoing = 0;
                fnt_CLEAR(gs);
            }

            else
            {
                repeat = 1;
                currDelta = deltaBase;
                currPointbase = 0;
            }

            break;
        case 1:
            /* opcode 1: advance delta, skipping zero */
            currPointbase = 0;

            while (repeat--)
            {
                currDelta += deltaDelta;

                if (currDelta == 0)
                    currDelta += deltaDelta;
            }

            repeat = 1;
            break;
        case 2:
            /* opcode 2: advance point base by 8 */
            currPointbase += (8 * repeat);
            repeat = 1;
            break;

        case 3:
            /* opcode 3: advance point base by 16 */
            currPointbase += (16 * repeat);
            repeat = 1;
            break;

        case 4:
            /* opcode 4: move a single point */
            point = get_huffman_operand_4(&phase, gs) + currPointbase;    /* always do this, even if the ppem doesn't match */

            if (currPPEM == renderingPPEM)
            {
                CHECK_PUSH(gs, gs->stackPointer, point);
                CHECK_PUSH(gs, gs->stackPointer, currDelta);
                fnt_SHPIX(gs);
                currPointbase = point + 2;
            }

            break;
        case 5:
            count = get_bitfield(3, &phase, gs) + 1;
            point = get_bitfield(3, &phase, gs) + currPointbase;

            if (currPPEM == renderingPPEM)
            {
                gs->loop = count - 1;
                currPointbase = point + count + (FS_LONG)(count < 8);

                while (count--)
                    CHECK_PUSH(gs, gs->stackPointer, point++);

                CHECK_PUSH(gs, gs->stackPointer, currDelta);
                fnt_SHPIX(gs);
            }

            break;
        case 6:
            /* opcode 6: set the repeat count */
            repeat = 4 + get_huffman_operand_6(&phase, gs);
            break;

        default:
            /* opcode 7: end of instructions */
            stillGoing = 0;
            fnt_CLEAR(gs);
            break;
        }   /* end switch */
    }   /* end while */
}   /* do_deltas_253 */

static FS_VOID fnt_DeltaKEngine(fnt_LocalGraphicStateType *gs, FS_SHORT base, FS_SHORT shift)
{
    fnt_ElementType* ce0 = gs->CE0;
    FS_LONG fakePixelsPerEm, aim = 0, tmp32;
    FS_LONG high, low = (FS_LONG)CHECK_POP(gs, gs->stackPointer );
    gs->stackPointer -= low;
    high = (FS_LONG)CHECK_POP(gs, gs->stackPointer );
    gs->stackPointer -= high;

    tmp32 = gs->globalGS->pixelsPerEm;
    if ( !gs->globalGS->identityTransformation )
        tmp32 = FixMul( tmp32, fnt_GetCVTScale( gs ) );

    fakePixelsPerEm = tmp32 - base;
    fakePixelsPerEm <<= 4;
    while ( aim < high )
    {
        FS_LONG tmp, ppem  = (FS_LONG)gs->stackPointer[ aim++ ];
        if ( (tmp = (ppem & ~0x0f)) == fakePixelsPerEm )
        {
            tmp = ppem & 0xf;
            tmp -= tmp >= 8 ? 7 : 8;
            tmp <<= fnt_pixelShift;
            tmp >>= shift;

            for ( aim = high + low; aim > high; aim-- )
            {
                FS_SHORT i, p = (FS_SHORT)gs->stackPointer[ aim ];
                int c = 0;
                while (p > ce0->ep[c]) c++;

                if ( gs->freedom.x )
                {
                    F26DOT6 dx = VECTORMUL( tmp, gs->freedom.x );
                    for ( i = c == 0 ? 0 : ce0->ep[c - 1] + 1; i <= ce0->ep[c]; i++ )
                    {
                        ce0->x[i] += dx;
                        ce0->f[i] |= XMOVED;
                    }
                }
                if ( gs->freedom.y )
                {
                    F26DOT6 dy = VECTORMUL( tmp, gs->freedom.y );
                    for ( i = c == 0 ? 0 : ce0->ep[c - 1] + 1; i <= ce0->ep[c]; i++ )
                    {
                        ce0->y[i] += dy;
                        ce0->f[i] |= YMOVED;
                    }
                }
            }

            break;
        }
        else if ( tmp > fakePixelsPerEm )
            break;
    }
}
static FS_VOID fnt_DELTAK1(fnt_LocalGraphicStateType *gs)
{
    fnt_ParameterBlock *pb = &gs->globalGS->localParBlock;
    fnt_DeltaKEngine( gs, pb->deltaBase, pb->deltaShift );
}

static FS_VOID fnt_DELTAK2(fnt_LocalGraphicStateType *gs)
{
    fnt_ParameterBlock *pb = &gs->globalGS->localParBlock;
    fnt_DeltaKEngine( gs, (FS_SHORT)(pb->deltaBase + 16), pb->deltaShift );
}

static FS_VOID fnt_DELTAK3(fnt_LocalGraphicStateType *gs)
{
    fnt_ParameterBlock *pb = &gs->globalGS->localParBlock;
    fnt_DeltaKEngine( gs, (FS_SHORT)(pb->deltaBase + 32), pb->deltaShift );
}
static FS_VOID fnt_DeltaLEngine(fnt_LocalGraphicStateType *gs, FS_SHORT base, FS_SHORT shift)
{
    fnt_ElementType* ce0 = gs->CE0;
    FS_LONG fakePixelsPerEm, aim = 0, tmp32;
    FS_SHORT p1 = (FS_SHORT)CHECK_POP(gs, gs->stackPointer );
    FS_LONG high = (FS_LONG)CHECK_POP(gs, gs->stackPointer );
    gs->stackPointer -= high;

    if ( ce0->onCurve[p1] )
    {
        tmp32 = gs->globalGS->pixelsPerEm;
        if ( !gs->globalGS->identityTransformation )
            tmp32 = FixMul( tmp32, fnt_GetCVTScale( gs ) );

        fakePixelsPerEm = tmp32 - base;
        fakePixelsPerEm <<= 4;
        while ( aim < high )
        {
            FS_LONG tmp, ppem  = (FS_LONG)gs->stackPointer[ aim++ ];
            if ( (tmp = (ppem & ~0x0f)) == fakePixelsPerEm )
            {
                F26DOT6 o;
                FS_SHORT p2 = p1, a, z, i;
                int contour = 0;
                while (p1 > ce0->ep[contour]) contour++;
                a = contour == 0 ? 0 : ce0->ep[contour - 1] + 1;
                z = ce0->ep[contour];
                o = gs->Project( gs, ce0->ox[p1], ce0->oy[p1] );

                while ( p2 < z && ce0->onCurve[p2 + 1] &&
                        gs->Project( gs, ce0->ox[p2 + 1], ce0->oy[p2 + 1] ) == o ) p2++;
                while ( p1 > a && ce0->onCurve[p1 - 1] &&
                        gs->Project( gs, ce0->ox[p1 - 1], ce0->oy[p1 - 1] ) == o ) p1--;

                tmp = ppem & 0xf;
                tmp -= tmp >= 8 ? 7 : 8;
                tmp <<= fnt_pixelShift;
                tmp >>= shift;
                if ( gs->freedom.x )
                {
                    F26DOT6 dx = VECTORMUL( tmp, gs->freedom.x );
                    for ( i = p1; i <= p2; i++ )
                    {
                        ce0->x[i] += dx;
                        ce0->f[i] |= XMOVED;
                    }
                }
                if ( gs->freedom.y )
                {
                    F26DOT6 dy = VECTORMUL( tmp, gs->freedom.y );
                    for ( i = p1; i <= p2; i++ )
                    {
                        ce0->y[i] += dy;
                        ce0->f[i] |= YMOVED;
                    }
                }

                break;
            }
            else if ( tmp > fakePixelsPerEm )
                break;
        }
    }
}
static FS_VOID fnt_DELTAL1(fnt_LocalGraphicStateType *gs)
{
    fnt_ParameterBlock *pb = &gs->globalGS->localParBlock;
    fnt_DeltaLEngine( gs, pb->deltaBase, pb->deltaShift );
}

static FS_VOID fnt_DELTAL2(fnt_LocalGraphicStateType *gs)
{
    fnt_ParameterBlock *pb = &gs->globalGS->localParBlock;
    fnt_DeltaLEngine( gs, (FS_SHORT)(pb->deltaBase + 16), pb->deltaShift );
}
static FS_VOID fnt_DELTAL3(fnt_LocalGraphicStateType *gs)
{
    fnt_ParameterBlock *pb = &gs->globalGS->localParBlock;
    fnt_DeltaLEngine( gs, (FS_SHORT)(pb->deltaBase + 32), pb->deltaShift );
}
static FS_VOID fnt_DeltaSEngine(fnt_LocalGraphicStateType *gs, FS_SHORT base, FS_SHORT shift)
{
    fnt_ElementType* ce0 = gs->CE0;
    FS_LONG fakePixelsPerEm, aim = 0, tmp32;
    FS_SHORT p = (FS_SHORT)CHECK_POP(gs, gs->stackPointer );
    FS_LONG high = (FS_LONG)CHECK_POP(gs, gs->stackPointer );
    gs->stackPointer -= high;

    if ( ce0->onCurve[p] )
    {
        tmp32 = gs->globalGS->pixelsPerEm;
        if ( !gs->globalGS->identityTransformation )
            tmp32 = FixMul( tmp32, fnt_GetCVTScale( gs ) );

        fakePixelsPerEm = tmp32 - base;
        fakePixelsPerEm <<= 4;
        while ( aim < high )
        {
            FS_LONG tmp, ppem  = (FS_LONG)gs->stackPointer[ aim++ ];
            if ( (tmp = (ppem & ~0x0f)) == fakePixelsPerEm )
            {
                F26DOT6 dx, dy, o;
                FS_SHORT i;

                tmp = ppem & 0xf;
                tmp -= tmp >= 8 ? 7 : 8;
                tmp <<= fnt_pixelShift;
                tmp >>= shift;

                dx = VECTORMUL( tmp, gs->freedom.x );
                dy = VECTORMUL( tmp, gs->freedom.y );
                o = gs->Project( gs, ce0->ox[p], ce0->oy[p] );
                for ( i = ce0->ep[ce0->nc - 1]; i >= 0; i-- )
                    if ( ce0->onCurve[i] && gs->Project( gs, ce0->ox[i], ce0->oy[i] ) == o )
                    {
                        if ( gs->freedom.x )
                        {
                            ce0->x[i] += dx;
                            ce0->f[i] |= XMOVED;
                        }
                        if ( gs->freedom.y )
                        {
                            ce0->y[i] += dy;
                            ce0->f[i] |= YMOVED;
                        }
                    }

                break;
            }
            else if ( tmp > fakePixelsPerEm )
                break;
        }
    }
}
static FS_VOID fnt_DELTAS1(fnt_LocalGraphicStateType *gs)
{
    fnt_ParameterBlock *pb = &gs->globalGS->localParBlock;
    fnt_DeltaSEngine( gs, pb->deltaBase, pb->deltaShift );
}
static FS_VOID fnt_DELTAS2(fnt_LocalGraphicStateType *gs)
{
    fnt_ParameterBlock *pb = &gs->globalGS->localParBlock;
    fnt_DeltaSEngine( gs, (FS_SHORT)(pb->deltaBase + 16), pb->deltaShift );

}
static FS_VOID fnt_DELTAS3(fnt_LocalGraphicStateType *gs)
{
    fnt_ParameterBlock *pb = &gs->globalGS->localParBlock;
    fnt_DeltaSEngine( gs, (FS_SHORT)(pb->deltaBase + 32), pb->deltaShift );
}

static FS_VOID fnt_MAZDELTA1(fnt_LocalGraphicStateType *gs)
{
    fnt_ParameterBlock *pb = &gs->globalGS->localParBlock;

    fnt_DeltaMAZEngine( gs, pb->deltaBase, pb->deltaShift );
}

static FS_VOID fnt_MAZDELTA2(fnt_LocalGraphicStateType *gs)
{
    fnt_ParameterBlock *pb = &gs->globalGS->localParBlock;

    fnt_DeltaMAZEngine( gs, (FS_SHORT)(pb->deltaBase + 16), pb->deltaShift );
}

static FS_VOID fnt_MAZDELTA3(fnt_LocalGraphicStateType *gs)
{
    fnt_ParameterBlock *pb = &gs->globalGS->localParBlock;

    fnt_DeltaMAZEngine( gs, (FS_SHORT)(pb->deltaBase + 32), pb->deltaShift );
}

static FS_VOID fnt_DeltaMAZEngine(fnt_LocalGraphicStateType *gs, FS_SHORT base, FS_SHORT shift)
{
#ifdef FS_EDGE_HINTS
    FS_SHORT point = (FS_SHORT)CHECK_POP(gs, gs->stackPointer );
    FS_LONG high = (FS_LONG)CHECK_POP(gs, gs->stackPointer );
    FS_LONG fakePixelsPerEm, aim = 0, tmp32;
    gs->stackPointer -= high;


    tmp32 = gs->globalGS->pixelsPerEm;
    if ( !gs->globalGS->identityTransformation )
        tmp32 = FixMul( tmp32, fnt_GetCVTScale( gs ) );

    fakePixelsPerEm = tmp32 - base;
    fakePixelsPerEm <<= 4;
    while ( aim < high )
    {
        FS_LONG tmp, ppem  = (FS_LONG)gs->stackPointer[ aim++ ];

        if ( (tmp = (ppem & ~0x0f)) == fakePixelsPerEm )
        {
            tmp = ppem & 0xf;
            tmp -= tmp >= 8 ? 7 : 8;
            tmp <<= fnt_pixelShift;
            tmp >>= shift;


            if ( gs->freedom.x )
            {
                gs->globalGS->maz_data.Xdeltashift[gs->globalGS->maz_data.numXdeltas] = tmp;
                gs->globalGS->maz_data.Xdeltapoint[gs->globalGS->maz_data.numXdeltas] = point;
                gs->globalGS->maz_data.numXdeltas++;
            }
            if ( gs->freedom.y )
            {
                gs->globalGS->maz_data.Ydeltashift[gs->globalGS->maz_data.numYdeltas] = tmp;
                gs->globalGS->maz_data.Ydeltapoint[gs->globalGS->maz_data.numYdeltas] = point;
                gs->globalGS->maz_data.numYdeltas++;
            }

            break;
        }
        else if ( tmp > fakePixelsPerEm )
            break;
    }
#else
    FS_LONG high = (FS_SHORT)CHECK_POP(gs, gs->stackPointer);
    high = (FS_LONG)CHECK_POP(gs, gs->stackPointer);   /*lint !e838*/
    gs->stackPointer -= high;

    (void)shift; /* unsued */
    (void)base;  /* unsued */
#endif /* FS_EDGE_HINTS */
}


static FS_VOID fnt_MAZMODE(fnt_LocalGraphicStateType *gs)
{
#ifdef FS_EDGE_HINTS
    FS_LONG mode;
    FS_LONG ppems, ppeme;

    mode  = CHECK_POP(gs, gs->stackPointer );
    ppems = CHECK_POP(gs, gs->stackPointer );
    ppeme = CHECK_POP(gs, gs->stackPointer );

    if (ppems <= gs->globalGS->pixelsPerEm && ppeme >= gs->globalGS->pixelsPerEm)
    {

        if (mode & MAZMODEMASK)
        {

            if (gs->freedom.y)
                gs->globalGS->maz_data.MAZmethodHorz = mode & MAZMODEMASK;
            if (gs->freedom.x)
                gs->globalGS->maz_data.MAZmethodVert = mode & MAZMODEMASK;
        }

    }
#else
    (FS_VOID) CHECK_POP(gs, gs->stackPointer);
    (FS_VOID) CHECK_POP(gs, gs->stackPointer);
    (FS_VOID) CHECK_POP(gs, gs->stackPointer);
#endif
}

static FS_VOID fnt_MAZSTROKE(fnt_LocalGraphicStateType *gs)
{
#ifdef FS_EDGE_HINTS
    FS_LONG ppems, ppeme;
    FS_LONG pt1;

    pt1   = CHECK_POP(gs, gs->stackPointer );
    ppems = CHECK_POP(gs, gs->stackPointer );
    ppeme = CHECK_POP(gs, gs->stackPointer );

    if (ppems <= gs->globalGS->pixelsPerEm && ppeme >= gs->globalGS->pixelsPerEm)
    {
        if (gs->freedom.y)
            gs->globalGS->maz_data.Hcollapse[gs->globalGS->maz_data.numHhints++] = pt1;
        if (gs->freedom.x)
            gs->globalGS->maz_data.Vcollapse[gs->globalGS->maz_data.numVhints++] = pt1;
    }
#else
    (FS_VOID) CHECK_POP(gs, gs->stackPointer);
    (FS_VOID) CHECK_POP(gs, gs->stackPointer);
    (FS_VOID) CHECK_POP(gs, gs->stackPointer);
#endif
}

FS_VOID BAZOutlineSmooth(fnt_LocalGraphicStateType *gs)
{
    fnt_ElementType* CE2 = gs->CE2;
    FS_LONG tmp32B;
    F26DOT6 *coord, *oCoord, *ooCoord;
    FS_LONG ctr;
    F26DOT6 dx, dx1, dx2;
    F26DOT6 dlow, dhigh;
    F26DOT6 tmp32, high, low;
    int mask;
    FS_LONG tmp16B;



    if ( gs->opCode & 0x01 )
    {
        /* do x */
        coord = CE2->x;
        oCoord = CE2->ox;
        ooCoord = CE2->oox;
        mask = XMOVED;
    }
    else
    {
        /* do y */
        coord = CE2->y;
        oCoord = CE2->oy;
        ooCoord = CE2->ooy;
        mask = YMOVED;
    }
    for ( ctr = 0; ctr < CE2->nc; ctr++ )
    {
        FS_LONG start = CE2->sp[ctr];
        FS_LONG tmp16 = CE2->ep[ctr];
        while ( !(CE2->f[start] & mask) && start <= tmp16 )
            start++;
        if ( start > tmp16 )
            continue;
        tmp16B = start;
        do
        {
            FS_LONG end;
            tmp16 = end = fnt_NextPt1( start, CE2, ctr );
            while ( !(CE2->f[end] & mask) )
            {
                end = fnt_NextPt1( end, CE2, ctr );
                if ( start == end )
                    break;
            }

            if ( ooCoord[start] < ooCoord[end] )
            {
                dx  = coord[start];
                dx1 = oCoord[start];
                dx2 = ooCoord[start];
                high = oCoord[end];
                dhigh = coord[end] - high;
                tmp32  = coord[end] - dx;
                tmp32B = ooCoord[end] - dx2;
            }
            else
            {
                dx  = coord[end];
                dx1 = oCoord[end];
                dx2 = ooCoord[end];
                high = oCoord[start];
                dhigh = coord[start] - high;
                tmp32  = coord[start] - dx;
                tmp32B = ooCoord[start] - dx2;
            }
            low = dx1;
            dlow = dx - dx1;

            if ( tmp32B )
            {
                if ( tmp32B < 32768L && tmp32 < 32768L )
                {
                    F26DOT6 corr = tmp32B >> 1;
                    while ( tmp16 != end )
                    {
                        F26DOT6 tmp32C = oCoord[tmp16];
                        if ( tmp32C <= low )
                            tmp32C += dlow;
                        else if ( tmp32C >= high )
                            tmp32C += dhigh;
                        else
                        {
                            tmp32C = ooCoord[tmp16];
                            tmp32C -= dx2;
                            tmp32C  = SHORTMUL(tmp32C, tmp32);
                            tmp32C += corr;
                            if ( tmp32C < 32768L )
                                tmp32C = SHORTDIV(tmp32C, tmp32B);
                            else
                                tmp32C /= (FS_SHORT)tmp32B;
                            tmp32C += dx;
                        }
                        coord[tmp16] = tmp32C;
                        tmp16 = fnt_NextPt1( tmp16, CE2, ctr);
                    }
                }
                else
                {
                    FS_FIXED ratio = 0;
                    int firstTime = 1;
                    while ( tmp16 != end )
                    {
                        F26DOT6 tmp32C = oCoord[tmp16];
                        if ( tmp32C <= low )
                            tmp32C += dlow;
                        else if ( tmp32C >= high )
                            tmp32C += dhigh;
                        else
                        {
                            if ( firstTime )
                            {
                                ratio = FixDiv( tmp32, tmp32B );
                                firstTime = 0;
                            }
                            tmp32C = ooCoord[tmp16];
                            tmp32C -= dx2;
                            tmp32C = FixMul( tmp32C, ratio );
                            tmp32C += dx;
                        }
                        coord[tmp16] = tmp32C;
                        tmp16 = fnt_NextPt1( tmp16, CE2, ctr);
                    }
                }
            }
            else
            {
                while ( tmp16 != end )
                {
                    coord[tmp16] += dx - dx1;
                    tmp16 = fnt_NextPt1( tmp16, CE2, ctr);
                }
            }
            start = end;
        }
        while ( start != tmp16B );
    }   /* for ( ctr = 0; ctr < CE2->nc; ctr++ ) */

}
#endif    /* ifdef-FS_HINTS */
